/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.ValuesBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.TimeSeriesBlockHash;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.compute.operator.Operator;

public final class TimeSeriesAggregationOperatorFactories {
    static List<GroupingAggregator.Factory> valuesAggregatorForGroupings(List<BlockHash.GroupSpec> groupings, int timeBucketChannel) {
        ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>();
        for (BlockHash.GroupSpec g : groupings) {
            if (g.channel() == timeBucketChannel) continue;
            AggregatorFunctionSupplier aggregatorSupplier = switch (g.elementType()) {
                default -> throw new IncompatibleClassChangeError();
                case ElementType.BYTES_REF -> new ValuesBytesRefAggregatorFunctionSupplier();
                case ElementType.DOUBLE -> new ValuesDoubleAggregatorFunctionSupplier();
                case ElementType.INT -> new ValuesIntAggregatorFunctionSupplier();
                case ElementType.LONG -> new ValuesLongAggregatorFunctionSupplier();
                case ElementType.BOOLEAN -> new ValuesBooleanAggregatorFunctionSupplier();
                case ElementType.FLOAT, ElementType.NULL, ElementType.DOC, ElementType.COMPOSITE, ElementType.UNKNOWN, ElementType.AGGREGATE_METRIC_DOUBLE -> throw new IllegalArgumentException("unsupported grouping type");
            };
            List<Integer> channels = List.of(Integer.valueOf(g.channel()));
            aggregators.add(aggregatorSupplier.groupingAggregatorFactory(AggregatorMode.SINGLE, channels));
        }
        return aggregators;
    }

    public record Final(List<BlockHash.GroupSpec> groupings, List<SupplierWithChannels> outerRates, List<SupplierWithChannels> nonRates, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>(this.outerRates.size() + this.nonRates.size());
            for (SupplierWithChannels f : this.outerRates) {
                aggregators.add(f.supplier.groupingAggregatorFactory(AggregatorMode.SINGLE, f.channels));
            }
            for (SupplierWithChannels f : this.nonRates) {
                aggregators.add(f.supplier.groupingAggregatorFactory(AggregatorMode.FINAL, f.channels));
            }
            return new HashAggregationOperator(aggregators, () -> BlockHash.build(this.groupings, driverContext.blockFactory(), this.maxPageSize, false), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesFinalAggregationOperatorFactory";
        }
    }

    public record Intermediate(int tsHashChannel, int timeBucketChannel, List<BlockHash.GroupSpec> groupings, List<SupplierWithChannels> rates, List<SupplierWithChannels> nonRates, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>(this.groupings.size() + this.rates.size() + this.nonRates.size());
            for (SupplierWithChannels f : this.rates) {
                aggregators.add(f.supplier.groupingAggregatorFactory(AggregatorMode.FINAL, f.channels));
            }
            for (SupplierWithChannels f : this.nonRates) {
                aggregators.add(f.supplier.groupingAggregatorFactory(AggregatorMode.INTERMEDIATE, f.channels));
            }
            aggregators.addAll(TimeSeriesAggregationOperatorFactories.valuesAggregatorForGroupings(this.groupings, this.timeBucketChannel));
            List<BlockHash.GroupSpec> hashGroups = List.of(new BlockHash.GroupSpec(this.tsHashChannel, ElementType.BYTES_REF), new BlockHash.GroupSpec(this.timeBucketChannel, ElementType.LONG));
            return new HashAggregationOperator(aggregators, () -> BlockHash.build(hashGroups, driverContext.blockFactory(), this.maxPageSize, false), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesIntermediateAggregationOperatorFactory";
        }
    }

    public record Initial(int tsHashChannel, int timeBucketChannel, List<BlockHash.GroupSpec> groupings, List<SupplierWithChannels> rates, List<SupplierWithChannels> nonRates, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>(this.groupings.size() + this.rates.size() + this.nonRates.size());
            for (SupplierWithChannels f : this.rates) {
                aggregators.add(f.supplier.groupingAggregatorFactory(AggregatorMode.INITIAL, f.channels));
            }
            for (SupplierWithChannels f : this.nonRates) {
                aggregators.add(f.supplier.groupingAggregatorFactory(AggregatorMode.INITIAL, f.channels));
            }
            aggregators.addAll(TimeSeriesAggregationOperatorFactories.valuesAggregatorForGroupings(this.groupings, this.timeBucketChannel));
            return new HashAggregationOperator(aggregators, () -> new TimeSeriesBlockHash(this.tsHashChannel, this.timeBucketChannel, driverContext), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesInitialAggregationOperatorFactory";
        }
    }

    public record SupplierWithChannels(AggregatorFunctionSupplier supplier, List<Integer> channels) {
    }
}

