/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.VTITemplate;

public final class StatementCache
extends VTITemplate {
    private int position = -1;
    private Vector<GenericPreparedStatement> data;
    private GenericPreparedStatement currentPs;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ID", 1, false, 36), EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("UNICODE", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("VALID", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("COMPILED_AT", 93, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public StatementCache() throws StandardException {
        DiagUtil.checkAccess();
        LanguageConnectionContext lcc = (LanguageConnectionContext)StatementCache.getContextOrNull("LanguageConnectionContext");
        CacheManager statementCache = lcc.getLanguageConnectionFactory().getStatementCache();
        if (statementCache != null) {
            Collection values = statementCache.values();
            this.data = new Vector(values.size());
            for (CachedStatement cs : values) {
                GenericPreparedStatement ps = cs.getPreparedStatement();
                this.data.add(ps);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.data == null) {
            return false;
        }
        ++this.position;
        while (this.position < this.data.size()) {
            this.currentPs = this.data.get(this.position);
            if (this.currentPs != null) {
                return true;
            }
            ++this.position;
        }
        this.data = null;
        return false;
    }

    @Override
    public void close() {
        this.data = null;
        this.currentPs = null;
    }

    @Override
    public String getString(int colId) {
        this.wasNull = false;
        switch (colId) {
            case 1: {
                return this.currentPs.getObjectName();
            }
            case 2: {
                return ((GenericStatement)this.currentPs.statement).getCompilationSchema();
            }
            case 3: {
                String sql = this.currentPs.getSource();
                sql = StringUtil.truncate(sql, 32672);
                return sql;
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean(int colId) {
        this.wasNull = false;
        switch (colId) {
            case 4: {
                return true;
            }
            case 5: {
                return this.currentPs.isValid();
            }
        }
        return false;
    }

    @Override
    public Timestamp getTimestamp(int colId) {
        Timestamp ts = this.currentPs.getEndCompileTimestamp();
        this.wasNull = ts == null;
        return ts;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }
}

