/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryFormatterFactory;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.spatial.BinaryShapeDocValuesField;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.Extent;
import org.elasticsearch.lucene.spatial.XYQueriesUtils;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.common.CartesianBoundingBox;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.AbstractAtomicCartesianShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.CartesianShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeParser;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeQueryable;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianShapeValuesSourceType;

public class ShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "shape";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), (Boolean)COERCE_SETTING.get(c.getSettings())));
    private final Builder builder;
    private final CartesianShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((ShapeFieldMapper)in).builder;
    }

    public ShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, AbstractGeometryFieldMapper.Parser<Geometry> parser, Builder builder) {
        super(simpleName, mappedFieldType, builderParams, builder.ignoreMalformed.get(), builder.coerce.get(), builder.ignoreZValue.get(), builder.orientation.get(), parser);
        this.builder = builder;
        this.indexer = new CartesianShapeIndexer(mappedFieldType.name());
    }

    @Override
    protected void index(DocumentParserContext context, Geometry geometry) {
        if (geometry == null) {
            return;
        }
        List<IndexableField> fields = this.indexer.indexShape(geometry);
        if (this.fieldType().isIndexed()) {
            context.doc().addAll(fields);
        }
        if (this.fieldType().hasDocValues()) {
            String name = this.fieldType().name();
            BinaryShapeDocValuesField docValuesField = (BinaryShapeDocValuesField)context.doc().getByKey(name);
            if (docValuesField == null) {
                docValuesField = new BinaryShapeDocValuesField(name, CoordinateEncoder.CARTESIAN);
                context.doc().addWithKey(name, docValuesField);
            }
            docValuesField.add(fields, geometry);
        } else if (this.fieldType().isIndexed()) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.builder.version, this.builder.ignoreMalformed.getDefaultValue().value(), this.builder.coerce.getDefaultValue().value()).init(this);
    }

    @Override
    public ShapeFieldType fieldType() {
        return (ShapeFieldType)super.fieldType();
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> ShapeFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Boolean> hasDocValues;
        private final IndexVersion version;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> ShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> ShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, IndexVersion version, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.version = version;
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> ShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> ShapeFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
            this.hasDocValues = FieldMapper.Parameter.docValuesParam(m -> ShapeFieldMapper.builder((FieldMapper)m).hasDocValues.get(), IndexVersions.V_8_4_0.onOrBefore(version));
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta};
        }

        @Override
        public ShapeFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "shape_multifields", "Adding multifields to [shape] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            GeometryParser geometryParser = new GeometryParser(this.orientation.get().value().getAsBoolean(), this.coerce.get().value(), this.ignoreZValue.get().value());
            ShapeParser parser = new ShapeParser(geometryParser);
            ShapeFieldType ft = new ShapeFieldType(context.buildFullName(this.leafName()), (boolean)this.indexed.get(), (boolean)this.hasDocValues.get(), this.orientation.get().value(), parser, context.isSourceSynthetic(), this.meta.get());
            return new ShapeFieldMapper(this.leafName(), ft, this.builderParams(this, context), parser, this);
        }
    }

    public static final class ShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry>
    implements ShapeQueryable {
        private final boolean isSyntheticSource;

        public ShapeFieldType(String name, boolean indexed, boolean hasDocValues, Orientation orientation, AbstractGeometryFieldMapper.Parser<Geometry> parser, boolean isSyntheticSource, Map<String, String> meta) {
            super(name, indexed, false, hasDocValues, parser, orientation, meta);
            this.isSyntheticSource = isSyntheticSource;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (a, b) -> new CartesianShapeIndexFieldData(this.name(), (ValuesSourceType)CartesianShapeValuesSourceType.instance(), CartesianShapeDocValuesField::new);
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(IndexVersions.V_7_5_0)) {
                throw new QueryShardException((QueryRewriteContext)context, String.valueOf(ShapeRelation.CONTAINS) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            try {
                return XYQueriesUtils.toXYShapeQuery(shape, fieldName, relation, this.isIndexed(), this.hasDocValues());
            }
            catch (IllegalArgumentException e) {
                throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
            }
        }

        @Override
        public String typeName() {
            return ShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        protected Function<List<Geometry>, List<Object>> getFormatter(String format) {
            return GeometryFormatterFactory.getFormatter(format, Function.identity());
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (blContext.fieldExtractPreference() == MappedFieldType.FieldExtractPreference.EXTRACT_SPATIAL_BOUNDS) {
                return new CartesianBoundsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return this.blockLoaderFromFallbackSyntheticSource(blContext);
            }
            return this.blockLoaderFromSource(blContext);
        }

        static class CartesianBoundsBlockLoader
        extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType.BoundsBlockLoader {
            protected CartesianBoundsBlockLoader(String fieldName) {
                super(fieldName);
            }

            @Override
            protected void writeExtent(BlockLoader.IntBuilder builder, Extent extent) {
                builder.beginPositionEntry();
                builder.appendInt(Math.min(extent.negLeft, extent.posLeft));
                builder.appendInt(Math.max(extent.negRight, extent.posRight));
                builder.appendInt(extent.top);
                builder.appendInt(extent.bottom);
                builder.endPositionEntry();
            }
        }
    }

    public static class CartesianShapeDocValuesField
    extends AbstractScriptFieldFactory<CartesianShapeValues.CartesianShapeValue>
    implements Field<CartesianShapeValues.CartesianShapeValue>,
    DocValuesScriptFieldFactory,
    ScriptDocValues.GeometrySupplier<CartesianPoint, CartesianShapeValues.CartesianShapeValue> {
        private final CartesianShapeValues in;
        protected final String name;
        private CartesianShapeValues.CartesianShapeValue value;
        private final CartesianPoint centroid = new CartesianPoint();
        private final CartesianBoundingBox boundingBox = new CartesianBoundingBox(new CartesianPoint(), new CartesianPoint());
        private ScriptDocValues<CartesianShapeValues.CartesianShapeValue> cartesianShapeScriptValues;

        public CartesianShapeDocValuesField(CartesianShapeValues in, String name) {
            this.in = in;
            this.name = name;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.value = (CartesianShapeValues.CartesianShapeValue)this.in.value();
                this.centroid.reset(this.value.getX(), this.value.getY());
                ((CartesianPoint)this.boundingBox.topLeft()).reset(this.value.boundingBox().minX(), this.value.boundingBox().maxY());
                ((CartesianPoint)this.boundingBox.bottomRight()).reset(this.value.boundingBox().maxX(), this.value.boundingBox().minY());
            } else {
                this.value = null;
            }
        }

        public ScriptDocValues<CartesianShapeValues.CartesianShapeValue> toScriptDocValues() {
            if (this.cartesianShapeScriptValues == null) {
                this.cartesianShapeScriptValues = new AbstractAtomicCartesianShapeFieldData.CartesianShapeScriptValues(this);
            }
            return this.cartesianShapeScriptValues;
        }

        @Override
        public CartesianShapeValues.CartesianShapeValue getInternal(int index) {
            if (index != 0) {
                throw new UnsupportedOperationException();
            }
            return this.value;
        }

        @Override
        public CartesianPoint getInternalCentroid() {
            return this.centroid;
        }

        public CartesianBoundingBox getInternalBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public CartesianPoint getInternalLabelPosition() {
            try {
                return new CartesianPoint(this.value.labelPosition());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to parse geo shape label position: " + e.getMessage(), e);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null;
        }

        @Override
        public int size() {
            return this.value == null ? 0 : 1;
        }

        public CartesianShapeValues.CartesianShapeValue get(CartesianShapeValues.CartesianShapeValue defaultValue) {
            return this.get(0, defaultValue);
        }

        public CartesianShapeValues.CartesianShapeValue get(int index, CartesianShapeValues.CartesianShapeValue defaultValue) {
            if (this.isEmpty() || index != 0) {
                return defaultValue;
            }
            return this.value;
        }

        @Override
        public Iterator<CartesianShapeValues.CartesianShapeValue> iterator() {
            return new Iterator<CartesianShapeValues.CartesianShapeValue>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < this.size();
                }

                @Override
                public CartesianShapeValues.CartesianShapeValue next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return value;
                }
            };
        }
    }
}

