/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.List;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.ESVectorUtil;

public class ByteKnnDenseVector
implements DenseVector {
    protected final byte[] docVector;
    protected float[] floatDocVector;
    protected boolean magnitudeCalculated = false;
    protected float magnitude;

    public ByteKnnDenseVector(byte[] vector) {
        this.docVector = vector;
    }

    @Override
    public float[] getVector() {
        if (this.floatDocVector == null) {
            this.floatDocVector = new float[this.docVector.length];
            for (int i = 0; i < this.docVector.length; ++i) {
                this.floatDocVector[i] = this.docVector[i];
            }
        }
        return this.floatDocVector;
    }

    @Override
    public float getMagnitude() {
        if (!this.magnitudeCalculated) {
            this.magnitude = DenseVector.getMagnitude(this.docVector, this.docVector.length);
            this.magnitudeCalculated = true;
        }
        return this.magnitude;
    }

    @Override
    public int dotProduct(byte[] queryVector) {
        return VectorUtil.dotProduct(this.docVector, queryVector);
    }

    @Override
    public double dotProduct(float[] queryVector) {
        throw new UnsupportedOperationException("use [int dotProduct(byte[] queryVector)] instead");
    }

    @Override
    public double dotProduct(List<Number> queryVector) {
        int result = 0;
        for (int i = 0; i < this.docVector.length; ++i) {
            result += this.docVector[i] * queryVector.get(i).intValue();
        }
        return result;
    }

    @SuppressForbidden(reason="used only for bytes so it cannot overflow")
    private static int abs(int value) {
        return Math.abs(value);
    }

    @Override
    public int l1Norm(byte[] queryVector) {
        int result = 0;
        for (int i = 0; i < this.docVector.length; ++i) {
            result += ByteKnnDenseVector.abs(this.docVector[i] - queryVector[i]);
        }
        return result;
    }

    @Override
    public double l1Norm(float[] queryVector) {
        throw new UnsupportedOperationException("use [int l1Norm(byte[] queryVector)] instead");
    }

    @Override
    public double l1Norm(List<Number> queryVector) {
        int result = 0;
        for (int i = 0; i < this.docVector.length; ++i) {
            result += ByteKnnDenseVector.abs(this.docVector[i] - queryVector.get(i).intValue());
        }
        return result;
    }

    @Override
    public int hamming(byte[] queryVector) {
        return ESVectorUtil.xorBitCount(queryVector, this.docVector);
    }

    @Override
    public int hamming(List<Number> queryVector) {
        int distance = 0;
        for (int i = 0; i < queryVector.size(); ++i) {
            distance += Integer.bitCount((queryVector.get(i).intValue() ^ this.docVector[i]) & 0xFF);
        }
        return distance;
    }

    @Override
    public double l2Norm(byte[] queryVector) {
        return Math.sqrt(VectorUtil.squareDistance(this.docVector, queryVector));
    }

    @Override
    public double l2Norm(float[] queryVector) {
        throw new UnsupportedOperationException("use [double l2Norm(byte[] queryVector)] instead");
    }

    @Override
    public double l2Norm(List<Number> queryVector) {
        int result = 0;
        for (int i = 0; i < this.docVector.length; ++i) {
            int diff = this.docVector[i] - queryVector.get(i).intValue();
            result += diff * diff;
        }
        return Math.sqrt(result);
    }

    @Override
    public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
        return (float)this.dotProduct(queryVector) / (qvMagnitude * this.getMagnitude());
    }

    @Override
    public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
        throw new UnsupportedOperationException("use [double cosineSimilarity(byte[] queryVector, float qvMagnitude)] instead");
    }

    @Override
    public double cosineSimilarity(List<Number> queryVector) {
        return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.docVector.length;
    }

    @Override
    public int size() {
        return 1;
    }
}

