/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.injection.guice.AbstractModule;
import org.elasticsearch.injection.guice.AbstractProcessor;
import org.elasticsearch.injection.guice.Binder;
import org.elasticsearch.injection.guice.Binding;
import org.elasticsearch.injection.guice.BoundProviderFactory;
import org.elasticsearch.injection.guice.ConstantFactory;
import org.elasticsearch.injection.guice.FactoryProxy;
import org.elasticsearch.injection.guice.Initializable;
import org.elasticsearch.injection.guice.Initializer;
import org.elasticsearch.injection.guice.Injector;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.InternalFactoryToProviderAdapter;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.MembersInjector;
import org.elasticsearch.injection.guice.Module;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.Scope;
import org.elasticsearch.injection.guice.Scopes;
import org.elasticsearch.injection.guice.TypeLiteral;
import org.elasticsearch.injection.guice.internal.BindingImpl;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InstanceBindingImpl;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.internal.LinkedBindingImpl;
import org.elasticsearch.injection.guice.internal.LinkedProviderBindingImpl;
import org.elasticsearch.injection.guice.internal.ProviderInstanceBindingImpl;
import org.elasticsearch.injection.guice.internal.Scoping;
import org.elasticsearch.injection.guice.internal.UntargettedBindingImpl;
import org.elasticsearch.injection.guice.spi.BindingTargetVisitor;
import org.elasticsearch.injection.guice.spi.InjectionPoint;
import org.elasticsearch.injection.guice.spi.InstanceBinding;
import org.elasticsearch.injection.guice.spi.LinkedKeyBinding;
import org.elasticsearch.injection.guice.spi.ProviderInstanceBinding;
import org.elasticsearch.injection.guice.spi.ProviderKeyBinding;
import org.elasticsearch.injection.guice.spi.UntargettedBinding;

class BindingProcessor
extends AbstractProcessor {
    private final List<CreationListener> creationListeners = new ArrayList<CreationListener>();
    private final Initializer initializer;
    private final List<Runnable> uninitializedBindings = new ArrayList<Runnable>();
    private static final Set<Class<?>> FORBIDDEN_TYPES = Set.of(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class);

    BindingProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        final Object source = command.getSource();
        if (Void.class.equals(command.getKey().getRawType())) {
            this.errors.missingConstantValues();
            return true;
        }
        final Key<T> key = command.getKey();
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        final Scoping scoping = ((BindingImpl)command).getScoping();
        command.acceptTargetVisitor(new BindingTargetVisitor<T, Void>(){

            @Override
            public Void visit(InstanceBinding<? extends T> binding) {
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, injectionPoints, instance));
                return null;
            }

            @Override
            public Void visit(ProviderInstanceBinding<? extends T> binding) {
                Provider provider = binding.getProviderInstance();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, source, injectionPoints);
                InternalFactoryToProviderAdapter factory = new InternalFactoryToProviderAdapter(initializable, source);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, provider, injectionPoints));
                return null;
            }

            @Override
            public Void visit(ProviderKeyBinding<? extends T> binding) {
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, source);
                BindingProcessor.this.creationListeners.add(boundProviderFactory);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, boundProviderFactory, scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, providerKey));
                return null;
            }

            @Override
            public Void visit(LinkedKeyBinding<? extends T> binding) {
                Key linkedKey = binding.getLinkedKey();
                if (key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, key, linkedKey, source);
                BindingProcessor.this.creationListeners.add(factory);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, linkedKey));
                return null;
            }

            @Override
            public Void visit(UntargettedBinding<? extends T> untargetted) {
                BindingImpl binding;
                if (key.hasAnnotationType()) {
                    BindingProcessor.this.errors.missingImplementation(key);
                    BindingProcessor.this.putBinding(BindingProcessor.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                try {
                    binding = BindingProcessor.this.injector.createUnitializedBinding(key, scoping, source, BindingProcessor.this.errors);
                    BindingProcessor.this.putBinding(binding);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                BindingProcessor.this.uninitializedBindings.add(() -> {
                    try {
                        ((InjectorImpl)binding.getInjector()).initializeBinding(binding, BindingProcessor.this.errors.withSource(source));
                    }
                    catch (ErrorsException e) {
                        BindingProcessor.this.errors.merge(e.getErrors());
                    }
                });
                return null;
            }

            @Override
            public Void visit() {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }
        });
        return true;
    }

    static <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key, Object source) {
        return new UntargettedBindingImpl<T>(injector, key, source);
    }

    public void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    public void runCreationListeners() {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.errors);
        }
    }

    private void putBinding(BindingImpl<?> binding) {
        Key<?> key = binding.getKey();
        Class<?> rawType = key.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.errors.cannotBindToGuiceType(rawType.getSimpleName());
            return;
        }
        BindingImpl<?> original = this.injector.state.getExplicitBinding(key);
        if (original != null) {
            this.errors.bindingAlreadySet(key, original.getSource());
            return;
        }
        this.injector.state.parent().blacklist(key);
        this.injector.state.putBinding(key, binding);
    }

    static interface CreationListener {
        public void notify(Errors var1);
    }
}

