/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentBuilder;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.xcontent.ToXContent;

public record HealthIndicatorResult(String name, HealthStatus status, String symptom, HealthIndicatorDetails details, List<HealthIndicatorImpact> impacts, List<Diagnosis> diagnosisList) implements ChunkedToXContentObject
{
    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).object(ob -> {
            ob.append((b, p) -> {
                b.field("status", this.status.xContentValue());
                b.field("symptom", this.symptom);
                if (this.details != null && !HealthIndicatorDetails.EMPTY.equals(this.details)) {
                    b.field("details", this.details, p);
                }
                if (this.impacts != null && !this.impacts.isEmpty()) {
                    b.field("impacts", (Iterable<?>)this.impacts);
                }
                return b;
            });
            if (this.diagnosisList != null && !this.diagnosisList.isEmpty()) {
                ob.array("diagnosis", this.diagnosisList.iterator(), ChunkedToXContentBuilder::append);
            }
        });
    }
}

