/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.admin.indices.refresh.TransportShardRefreshAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.TransportGetFromTranslogAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAction
extends TransportSingleShardAction<GetRequest, GetResponse> {
    public static final ActionType<GetResponse> TYPE = new ActionType("indices:data/read/get");
    private static final Logger logger = LogManager.getLogger(TransportGetAction.class);
    private final IndicesService indicesService;
    private final ExecutorSelector executorSelector;
    private final NodeClient client;

    @Inject
    public TransportGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ExecutorSelector executorSelector, NodeClient client) {
        super(TYPE.name(), threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetRequest::new, threadPool.executor("get"));
        this.indicesService = indicesService;
        this.executorSelector = executorSelector;
        this.client = client;
        new TransportGetFromTranslogAction(transportService, indicesService, actionFilters);
    }

    @Override
    protected boolean resolveIndex(GetRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ShardIterator iterator = this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((GetRequest)request.request()).id(), ((GetRequest)request.request()).routing(), ((GetRequest)request.request()).preference());
        if (iterator == null) {
            return null;
        }
        return ShardIterator.allSearchableShards(iterator);
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((GetRequest)request.request()).routing(state.metadata().resolveIndexRouting(((GetRequest)request.request()).routing(), ((GetRequest)request.request()).index()));
    }

    @Override
    protected void asyncShardOperation(GetRequest request, ShardId shardId, ActionListener<GetResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (!indexShard.routingEntry().isPromotableToPrimary()) {
            this.handleGetOnUnpromotableShard(request, indexShard, listener);
            return;
        }
        assert (!DiscoveryNode.isStateless(this.clusterService.getSettings())) : "in Stateless a promotable to primary shard should not receive a TransportGetAction";
        if (request.realtime()) {
            this.asyncGet(request, shardId, listener);
        } else {
            indexShard.ensureShardSearchActive(b -> {
                try {
                    this.asyncGet(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, ShardId shardId) throws IOException {
        IndexShard indexShard = this.getIndexShard(shardId);
        GetResult result = indexShard.getService().get(request.id(), request.storedFields(), request.realtime(), request.version(), request.versionType(), request.fetchSourceContext(), request.isForceSyntheticSource());
        return new GetResponse(result);
    }

    @Override
    protected Writeable.Reader<GetResponse> getResponseReader() {
        return GetResponse::new;
    }

    @Override
    protected Executor getExecutor(GetRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().getIndexSafe(shardId.getIndex()).isSystem()) {
            return this.threadPool.executor(this.executorSelector.executorForGet(shardId.getIndexName()));
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return this.threadPool.executor("search_throttled");
        }
        return super.getExecutor(request, shardId);
    }

    private void asyncGet(GetRequest request, ShardId shardId, ActionListener<GetResponse> listener) throws IOException {
        if (request.refresh() && !request.realtime()) {
            this.getExecutor(request, shardId).execute(ActionRunnable.wrap(listener, l -> {
                IndexShard indexShard = this.getIndexShard(shardId);
                indexShard.externalRefresh("refresh_flag_get", l.map(r -> this.shardOperation(request, shardId)));
            }));
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    private void handleGetOnUnpromotableShard(GetRequest request, IndexShard indexShard, ActionListener<GetResponse> listener) throws IOException {
        ShardId shardId = indexShard.shardId();
        if (request.refresh()) {
            logger.trace("send refresh action for shard {}", (Object)shardId);
            BasicReplicationRequest refreshRequest = new BasicReplicationRequest(shardId);
            refreshRequest.setParentTask(request.getParentTask());
            this.client.executeLocally(TransportShardRefreshAction.TYPE, refreshRequest, listener.delegateFailureAndWrap((l, replicationResponse) -> super.asyncShardOperation(request, shardId, l)));
            return;
        }
        if (request.realtime()) {
            ClusterState state = this.clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService, TimeValue.timeValueSeconds(60L), logger, this.threadPool.getThreadContext());
            this.getFromTranslog(request, indexShard, state, observer, listener);
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    private void getFromTranslog(final GetRequest request, final IndexShard indexShard, ClusterState state, final ClusterStateObserver observer, ActionListener<GetResponse> listener) {
        DiscoveryNode node;
        try {
            node = TransportGetAction.getCurrentNodeOfPrimary(state, indexShard.shardId());
        }
        catch (Exception e2) {
            listener.onFailure(e2);
            return;
        }
        ActionListener<GetResponse> retryingListener = listener.delegateResponse((l, e) -> {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            logger.debug("get_from_translog failed", cause);
            if (cause instanceof ShardNotFoundException || cause instanceof IndexNotFoundException) {
                logger.debug("retrying get_from_translog");
                observer.waitForNextChange(new ClusterStateObserver.Listener(){
                    final /* synthetic */ ActionListener val$l;
                    final /* synthetic */ Throwable val$cause;
                    {
                        this.val$l = actionListener;
                        this.val$cause = throwable;
                    }

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        TransportGetAction.this.getFromTranslog(request, indexShard, state, observer, this.val$l);
                    }

                    @Override
                    public void onClusterServiceClose() {
                        this.val$l.onFailure(new NodeClosedException(TransportGetAction.this.clusterService.localNode()));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        this.val$l.onFailure(new ElasticsearchException("Timed out retrying get_from_translog", this.val$cause, new Object[0]));
                    }
                });
            } else {
                l.onFailure((Exception)e);
            }
        });
        this.tryGetFromTranslog(request, indexShard, node, retryingListener);
    }

    private void tryGetFromTranslog(GetRequest request, IndexShard indexShard, DiscoveryNode node, ActionListener<GetResponse> listener) {
        ShardId shardId = indexShard.shardId();
        TransportGetFromTranslogAction.Request getFromTranslogRequest = new TransportGetFromTranslogAction.Request(request, shardId);
        getFromTranslogRequest.setParentTask(request.getParentTask());
        this.transportService.sendRequest(node, "indices:data/read/get_from_translog", getFromTranslogRequest, new ActionListenerResponseHandler<TransportGetFromTranslogAction.Response>(listener.delegateFailure((l, r) -> {
            if (r.getResult() != null) {
                logger.debug("received result for real-time get for id '{}' from promotable shard", (Object)request.id());
                l.onResponse(new GetResponse(r.getResult()));
            } else {
                logger.debug("no result for real-time get for id '{}' from promotable shard (segment generation to wait for: {})", (Object)request.id(), (Object)r.segmentGeneration());
                if (r.segmentGeneration() == -1L) {
                    ActionRunnable.supply(l, () -> this.shardOperation(request, shardId)).run();
                } else {
                    assert (r.segmentGeneration() > -1L);
                    assert (r.primaryTerm() > -1L);
                    indexShard.waitForPrimaryTermAndGeneration(r.primaryTerm(), r.segmentGeneration(), listener.delegateFailureAndWrap((ll, aLong) -> super.asyncShardOperation(request, shardId, ll)));
                }
            }
        }), TransportGetFromTranslogAction.Response::new, this.getExecutor(request, shardId)));
    }

    static DiscoveryNode getCurrentNodeOfPrimary(ClusterState clusterState, ShardId shardId) {
        ShardRouting primaryShard = clusterState.routingTable().shardRoutingTable(shardId).primaryShard();
        if (!primaryShard.active()) {
            throw new NoShardAvailableActionException(shardId, "primary shard is not active");
        }
        DiscoveryNode node = clusterState.nodes().get(primaryShard.currentNodeId());
        assert (node != null);
        return node;
    }

    private IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getShard(shardId.id());
    }
}

