# frozen_string_literal: true
class Views::SharedTogo::NotFound < ::Views::Base
  def view_title
    '404'
  end

  def content
    widget(
      Views::SharedTogo::Head,
      :product => 'enterprise-search',
      :view_title => view_title,
      :stylesheet_link_tags => ['shared_togo/enterprise_search_home'],
      :stylesheet_packs_with_chunks_tags => ['eui'],
      :javascript_packs_with_chunks_tags => []
    )
    widget(Views::SharedTogo::ErrorBody, :view_title => view_title) do
      div(:class => 'euiFlexGroup euiFlexGroup--directionColumn euiFlexGroup--gutterLarge euiFlexGroup--alignItemsCenter') do
        image_tag('shared/error/404-illustration.png', :class => 'euiFlexItem')
        div(:class => 'euiTitle euiTitle--medium euiFlexItem') do
          h1 'Enterprise Search has moved'
        end
        p(:class => 'euiFlexItem euiText euiText--small euiTextAlign--center') do
          text 'Enterprise Search has moved into Kibana. Since version 8.0, the standalone user interface is no longer available. Manage App Search, Workplace Search, and all other Elastic features in one place!'
        end
        div(:class => 'euiFlexItem') do
          button(:class => 'euiButton euiButton--primary euiButton--fill') do
            span(:class => 'euiButtonContent euiButton__content') do
              a('Open Kibana', :href => SharedTogo.kibana_enterprise_search_url, :class => 'euiButton__text')
            end
          end
        end
      end
    end
  end
end
