/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ServletRackIncludedResponse
extends HttpServletResponseWrapper {
    private static final int BUFFER_SIZE = 16384;
    private int bufferSize = 16384;
    private ServletResponse wrappedResponse;
    private PrintWriter writer;
    private ServletOutputStream outputStream;
    private ByteArrayOutputStream outputStreamBuffer;

    public ServletRackIncludedResponse(HttpServletResponse response) {
        super(response);
        this.wrappedResponse = response;
    }

    public String getOutput() throws IOException {
        this.flushBuffer();
        String charEnc = super.getResponse().getCharacterEncoding();
        return this.outputStreamBuffer.toString(charEnc);
    }

    public ServletResponse getResponse() {
        return this.wrappedResponse;
    }

    public void setResponse(ServletResponse response) {
        this.wrappedResponse = response;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.outputStream == null) {
            this.initializeOutputStream();
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException, IllegalStateException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        if (this.writer == null) {
            this.initializeWriter();
        }
        return this.writer;
    }

    public void reset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot reset an included response");
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Illegal call to resetBuffer() after response has been committed");
        }
        if (this.writer != null) {
            try {
                this.initializeWriter();
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        } else if (this.outputStream != null) {
            this.initializeOutputStream();
        }
    }

    private void initializeWriter() throws UnsupportedEncodingException {
        String charSet = super.getResponse().getCharacterEncoding();
        this.outputStreamBuffer = new ByteArrayOutputStream(this.bufferSize);
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStreamBuffer, charSet));
    }

    private void initializeOutputStream() {
        String charSet = super.getResponse().getCharacterEncoding();
        this.outputStreamBuffer = new ByteArrayOutputStream(this.bufferSize);
        this.outputStream = new ByteArrayServletOutputStream(this.outputStreamBuffer, charSet);
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final DataOutputStream dataOutputStream;
        private final String charSet;

        public ByteArrayServletOutputStream(ByteArrayOutputStream byteOutputStream, String charSet) {
            this.dataOutputStream = new DataOutputStream(byteOutputStream);
            this.charSet = charSet;
        }

        public void print(boolean b) throws IOException {
            this.dataOutputStream.writeBoolean(b);
        }

        public void print(char c) throws IOException {
            this.dataOutputStream.writeChar(c);
        }

        public void print(double d) throws IOException {
            this.dataOutputStream.writeDouble(d);
        }

        public void print(float f) throws IOException {
            this.dataOutputStream.writeFloat(f);
        }

        public void print(int i) throws IOException {
            this.dataOutputStream.write(i);
        }

        public void print(long l) throws IOException {
            this.dataOutputStream.writeLong(l);
        }

        public void print(String s) throws IOException {
            this.dataOutputStream.write(s.getBytes(this.charSet));
        }

        public void println() throws IOException {
            this.dataOutputStream.write(LINE_SEPARATOR.getBytes(this.charSet));
        }

        public void println(boolean b) throws IOException {
            this.print(b);
            this.println();
        }

        public void println(char c) throws IOException {
            this.print(c);
            this.println();
        }

        public void println(double d) throws IOException {
            this.print(d);
            this.println();
        }

        public void println(float f) throws IOException {
            this.print(f);
            this.println();
        }

        public void println(int i) throws IOException {
            this.print(i);
            this.println();
        }

        public void println(long l) throws IOException {
            this.print(l);
            this.println();
        }

        public void println(String s) throws IOException {
            this.print(s);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.dataOutputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.dataOutputStream.write(b);
        }

        public void write(int i) throws IOException {
            this.dataOutputStream.write(i);
        }
    }
}

