/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackLogger;
import org.jruby.rack.servlet.ServletRackConfig;
import org.jruby.rack.servlet.ServletRackContext;

public class DefaultServletRackContext
implements ServletRackContext {
    private final RackConfig config;
    private final ServletContext context;
    private final RackLogger logger;

    public DefaultServletRackContext(ServletRackConfig config) {
        this.config = config;
        this.context = config.getServletContext();
        this.logger = config.getLogger();
    }

    ServletContext getRealContext() {
        return this.getContext();
    }

    public static ServletContext getRealContext(ServletContext context) {
        if (context instanceof DefaultServletRackContext) {
            return ((DefaultServletRackContext)context).getRealContext();
        }
        return context;
    }

    @Override
    public RackApplicationFactory getRackFactory() {
        return (RackApplicationFactory)this.getAttribute("rack.factory");
    }

    @Override
    public RackConfig getConfig() {
        return this.config;
    }

    public String getInitParameter(String key) {
        return this.config.getProperty(key);
    }

    public String getRealPath(String path) {
        String realPath = this.context.getRealPath(path);
        if (realPath == null) {
            try {
                URL url = this.context.getResource(path);
                if (url != null) {
                    String urlPath = url.getPath();
                    realPath = urlPath.startsWith("file:") ? new URL(urlPath).getPath() : urlPath;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return realPath;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public ServletContext getContext(String path) {
        return this.context.getContext(path);
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return this.context.getServlet(name);
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return this.context.getServlets();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return this.context.getServletNames();
    }

    @Override
    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public Object getAttribute(String key) {
        return this.context.getAttribute(key);
    }

    public Enumeration<String> getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public void setAttribute(String key, Object val) {
        this.context.setAttribute(key, val);
    }

    public void removeAttribute(String key) {
        this.context.removeAttribute(key);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    @Deprecated
    public void log(Exception e, String msg) {
        this.logger.log(msg, e);
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        return this.logger.isEnabled(level);
    }

    @Override
    public void log(String message) {
        this.logger.log(message);
    }

    @Override
    public void log(String message, Throwable e) {
        this.logger.log(message, e);
    }

    @Override
    @Deprecated
    public void log(String level, String message) {
        this.logger.log(level, message);
    }

    @Override
    @Deprecated
    public void log(String level, String message, Throwable e) {
        this.logger.log(level, message, e);
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        this.logger.log(level, message);
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable e) {
        this.logger.log(level, message, e);
    }

    public int getEffectiveMajorVersion() throws UnsupportedOperationException {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() throws UnsupportedOperationException {
        return this.context.getEffectiveMinorVersion();
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public boolean setInitParameter(String name, String value) {
        return this.context.setInitParameter(name, value);
    }

    public void declareRoles(String ... roleNames) {
        this.context.declareRoles(roleNames);
    }

    public <T extends Servlet> T createServlet(Class<T> type) throws ServletException {
        return (T)this.context.createServlet(type);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) throws IllegalArgumentException, IllegalStateException {
        return this.context.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) throws IllegalArgumentException, IllegalStateException {
        return this.context.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) throws IllegalArgumentException, IllegalStateException {
        return this.context.addServlet(servletName, servletClass);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    public <T extends Filter> T createFilter(Class<T> type) throws ServletException {
        return (T)this.context.createFilter(type);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) throws IllegalArgumentException, IllegalStateException {
        return this.context.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) throws IllegalArgumentException, IllegalStateException {
        return this.context.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) throws IllegalArgumentException, IllegalStateException {
        return this.context.addFilter(filterName, filterClass);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.context.addListener(listenerClass);
    }

    public void addListener(String className) {
        this.context.addListener(className);
    }

    public <T extends EventListener> void addListener(T listener) {
        this.context.addListener(listener);
    }

    public <T extends EventListener> T createListener(Class<T> listenerClass) throws ServletException {
        return (T)this.context.createListener(listenerClass);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }
}

