/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.core;

import co.elastic.thumbnails4j.core.Dimensions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.swing.JEditorPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class ThumbnailUtils {
    private static Dimensions MAX_IN_MEMORY_BUFFER = new Dimensions(310, 430);

    public static Dimensions getMaxInMemoryBuffer() {
        return MAX_IN_MEMORY_BUFFER;
    }

    public static void setMaxInMemoryBuffer(Dimensions maxInMemoryBuffer) {
        MAX_IN_MEMORY_BUFFER = maxInMemoryBuffer;
    }

    public static BufferedImage scaleImage(BufferedImage image, Dimensions dimensions) {
        return ThumbnailUtils.scaleImage(image, dimensions, image.getType());
    }

    public static BufferedImage scaleImage(BufferedImage image, Dimensions dimensions, int imageType) {
        int scaledWidth = image.getWidth();
        int scaledHeight = image.getHeight();
        double widthRatio = (double)scaledWidth / (double)dimensions.getWidth();
        double heightRatio = (double)scaledHeight / (double)dimensions.getHeight();
        double aspectRatio = Math.max(widthRatio, heightRatio);
        int targetWidth = (int)Math.round((double)scaledWidth / aspectRatio);
        int targetHeight = (int)Math.round((double)scaledHeight / aspectRatio);
        while (scaledWidth != targetWidth || scaledHeight != targetHeight) {
            scaledWidth = ThumbnailUtils.scaleDimension(scaledWidth, targetWidth);
            scaledHeight = ThumbnailUtils.scaleDimension(scaledHeight, targetHeight);
            BufferedImage temp = new BufferedImage(scaledWidth, scaledHeight, imageType);
            Graphics2D graphics = temp.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
            graphics.dispose();
            image = temp;
        }
        return image;
    }

    public static Dimensions memoryOptimiseDimension(Dimensions dimensions) {
        if (dimensions.does_fit_inside(MAX_IN_MEMORY_BUFFER)) {
            return dimensions;
        }
        double givenXYRatio = (double)dimensions.getWidth() / (double)dimensions.getHeight();
        Dimensions result = new Dimensions(dimensions.getWidth(), dimensions.getHeight());
        double destXYRatio = (double)MAX_IN_MEMORY_BUFFER.getWidth() / (double)MAX_IN_MEMORY_BUFFER.getHeight();
        if (givenXYRatio > destXYRatio) {
            result.setWidth(MAX_IN_MEMORY_BUFFER.getWidth());
            result.setHeight((int)((double)MAX_IN_MEMORY_BUFFER.getWidth() / givenXYRatio));
        } else {
            result.setHeight(MAX_IN_MEMORY_BUFFER.getHeight());
            result.setWidth((int)((double)MAX_IN_MEMORY_BUFFER.getHeight() * givenXYRatio));
        }
        return result;
    }

    public static Transformer getTransformerForXhtmlDOM() throws TransformerConfigurationException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return transformer;
    }

    public static BufferedImage htmlToImage(JEditorPane htmlComponent, Dimensions dimensions) {
        Dimensions optimizedDimensions = ThumbnailUtils.memoryOptimiseDimension(dimensions);
        double scale_factor = (double)optimizedDimensions.getWidth() / (double)dimensions.getWidth();
        BufferedImage image = new BufferedImage(optimizedDimensions.getWidth(), optimizedDimensions.getHeight(), 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, optimizedDimensions.getWidth(), optimizedDimensions.getHeight()));
        graphics.scale(scale_factor, scale_factor);
        htmlComponent.print(graphics);
        graphics.dispose();
        return image;
    }

    public static BufferedImage scaleHtmlToImage(byte[] htmlBytes, Dimensions dimensions) throws UnsupportedEncodingException {
        JEditorPane htmlComponent = new JEditorPane("text/html", new String(htmlBytes, StandardCharsets.UTF_8));
        Dimension preferredSize = htmlComponent.getPreferredSize();
        int width = preferredSize.width;
        double ratio = (double)width / (double)dimensions.getWidth();
        int height = (int)(ratio * (double)dimensions.getHeight());
        htmlComponent.setSize(width, height);
        return ThumbnailUtils.htmlToImage(htmlComponent, new Dimensions(width, height));
    }

    public static BufferedImage clipHtmlToImage(byte[] htmlBytes, Dimensions dimensions) {
        JEditorPane htmlComponent = new JEditorPane("text/html", new String(htmlBytes, StandardCharsets.UTF_8));
        Dimension preferredSize = htmlComponent.getPreferredSize();
        htmlComponent.setSize(preferredSize.width, preferredSize.height);
        return ThumbnailUtils.htmlToImage(htmlComponent, dimensions);
    }

    private static int scaleDimension(int value, int targetValue) {
        if (value > targetValue) {
            return Math.max(value / 2, targetValue);
        }
        if (value < targetValue) {
            return Math.min(value * 2, targetValue);
        }
        return value;
    }
}

