/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.search.lookup.SearchLookup;

public class FailingFieldPlugin
extends Plugin
implements ScriptPlugin {
    public static final String FAILING_FIELD_LANG = "failing_field";

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new ScriptEngine(){

            public String getType() {
                return FailingFieldPlugin.FAILING_FIELD_LANG;
            }

            public <FactoryType> FactoryType compile(String name, String code, ScriptContext<FactoryType> context, Map<String, String> params) {
                return (FactoryType)new LongFieldScript.Factory(){

                    public LongFieldScript.LeafFactory newFactory(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError) {
                        return ctx -> new LongFieldScript(fieldName, params, searchLookup, onScriptError, ctx){

                            public void execute() {
                                throw new IllegalStateException("Accessing failing field");
                            }
                        };
                    }
                };
            }

            public Set<ScriptContext<?>> getSupportedContexts() {
                return Set.of(LongFieldScript.CONTEXT);
            }
        };
    }
}

