/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.lucene.tests.mockfile.FilterFileSystem;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;

class TestPathLookup
implements PathLookup {
    private final Map<PathLookup.BaseDir, Collection<Path>> baseDirPaths = new ConcurrentHashMap<PathLookup.BaseDir, Collection<Path>>();

    TestPathLookup(Path tempDir) {
        this.baseDirPaths.put(PathLookup.BaseDir.TEMP, List.of(tempDir));
    }

    public Path pidFile() {
        return null;
    }

    public Stream<Path> getBaseDirPaths(PathLookup.BaseDir baseDir) {
        return ((Collection)this.baseDirPaths.getOrDefault(baseDir, List.of())).stream();
    }

    public Stream<Path> resolveSettingPaths(PathLookup.BaseDir baseDir, String settingName) {
        return Stream.empty();
    }

    public boolean isPathOnDefaultFilesystem(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem.getClass() != DEFAULT_FILESYSTEM_CLASS) {
            while (fileSystem instanceof FilterFileSystem) {
                FilterFileSystem ffs = (FilterFileSystem)fileSystem;
                fileSystem = ffs.getDelegate();
            }
        }
        return fileSystem.getClass() == DEFAULT_FILESYSTEM_CLASS;
    }

    void reset() {
        this.baseDirPaths.keySet().retainAll(List.of(PathLookup.BaseDir.TEMP));
    }

    void add(PathLookup.BaseDir baseDir, Path ... paths) {
        this.baseDirPaths.compute(baseDir, TestPathLookup.baseDirModifier(Collection::add, paths));
    }

    void remove(PathLookup.BaseDir baseDir, Path ... paths) {
        this.baseDirPaths.compute(baseDir, TestPathLookup.baseDirModifier(Collection::remove, paths));
    }

    private static BiFunction<PathLookup.BaseDir, Collection<Path>, Collection<Path>> baseDirModifier(BiConsumer<Collection<Path>, Path> operation, Path ... updates) {
        return (baseDir, paths) -> {
            paths = paths == null ? new ArrayList() : new ArrayList(paths);
            for (Path update : updates) {
                operation.accept((Collection<Path>)paths, update);
            }
            return Collections.unmodifiableCollection(paths);
        };
    }
}

