/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.VersionInformation;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.node.Node;
import org.elasticsearch.test.ESTestCase;

public class DiscoveryNodeUtils {
    public static DiscoveryNode create(String id) {
        return DiscoveryNodeUtils.builder(id).build();
    }

    public static DiscoveryNode create(String name, String id) {
        return DiscoveryNodeUtils.builder(id).name(name).build();
    }

    public static DiscoveryNode create(String id, TransportAddress address) {
        return DiscoveryNodeUtils.builder(id).address(address).build();
    }

    public static DiscoveryNode create(String id, TransportAddress address, Version version) {
        return DiscoveryNodeUtils.builder(id).address(address).version(version).build();
    }

    public static DiscoveryNode create(String id, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles) {
        return DiscoveryNodeUtils.builder(id).address(address).attributes(attributes).roles(roles).build();
    }

    public static DiscoveryNode create(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles) {
        return DiscoveryNodeUtils.builder(nodeId).name(nodeName).address(address).attributes(attributes).roles(roles).build();
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static class Builder {
        private final String id;
        private String name;
        private String ephemeralId = UUIDs.randomBase64UUID();
        private String hostName;
        private String hostAddress;
        private TransportAddress address;
        private Map<String, String> attributes = Map.of();
        private Set<DiscoveryNodeRole> roles = DiscoveryNodeRole.roles();
        private Version version;
        private IndexVersion minIndexVersion;
        private IndexVersion minReadOnlyIndexVersion;
        private IndexVersion maxIndexVersion;
        private String externalId;

        private Builder(String id) {
            this.id = Objects.requireNonNull(id);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ephemeralId(String ephemeralId) {
            this.ephemeralId = Objects.requireNonNull(ephemeralId);
            return this;
        }

        public Builder address(TransportAddress address) {
            return this.address(null, null, address);
        }

        public Builder address(String hostName, String hostAddress, TransportAddress address) {
            this.hostName = hostName;
            this.hostAddress = hostAddress;
            this.address = Objects.requireNonNull(address);
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = Objects.requireNonNull(attributes);
            return this;
        }

        public Builder roles(Set<DiscoveryNodeRole> roles) {
            this.roles = Objects.requireNonNull(roles);
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder version(Version version, IndexVersion minIndexVersion, IndexVersion maxIndexVersion) {
            this.version = version;
            this.minIndexVersion = minIndexVersion;
            this.minReadOnlyIndexVersion = minIndexVersion;
            this.maxIndexVersion = maxIndexVersion;
            return this;
        }

        public Builder version(VersionInformation versions) {
            this.version = versions.nodeVersion();
            this.minIndexVersion = versions.minIndexVersion();
            this.minReadOnlyIndexVersion = versions.minReadOnlyIndexVersion();
            this.maxIndexVersion = versions.maxIndexVersion();
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder applySettings(Settings settings) {
            return this.name((String)Node.NODE_NAME_SETTING.get(settings)).attributes(Node.NODE_ATTRIBUTES.getAsMap(settings)).roles(DiscoveryNode.getRolesFromSettings((Settings)settings)).externalId((String)Node.NODE_EXTERNAL_ID_SETTING.get(settings));
        }

        public DiscoveryNode build() {
            if (this.address == null) {
                this.address = ESTestCase.buildNewFakeTransportAddress();
            }
            if (this.hostName == null) {
                this.hostName = this.address.address().getHostString();
            }
            if (this.hostAddress == null) {
                this.hostAddress = this.address.getAddress();
            }
            VersionInformation versionInfo = this.minIndexVersion == null || this.minReadOnlyIndexVersion == null || this.maxIndexVersion == null ? VersionInformation.inferVersions((Version)this.version) : new VersionInformation(this.version, this.minIndexVersion, this.minReadOnlyIndexVersion, this.maxIndexVersion);
            return new DiscoveryNode(this.name, this.id, this.ephemeralId, this.hostName, this.hostAddress, this.address, this.attributes, this.roles, versionInfo, this.externalId);
        }
    }
}

