/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;

public class KnnScoreDocQuery
extends Query {
    private final float maxScore;
    private final int[] docs;
    private final float[] scores;
    private final int[] segmentStarts;
    private final Object contextIdentity;

    static Query fromQuery(Query query, int k, IndexSearcher searcher) throws IOException {
        if (query instanceof MatchNoDocsQuery) {
            return query;
        }
        if (query instanceof KnnScoreDocQuery) {
            KnnScoreDocQuery knnQuery = (KnnScoreDocQuery)query;
            return knnQuery;
        }
        TopDocs topDocs = searcher.search(query, k);
        return new KnnScoreDocQuery(topDocs.scoreDocs, searcher.getIndexReader());
    }

    KnnScoreDocQuery(ScoreDoc[] scoreDocs, IndexReader reader) {
        Arrays.sort(scoreDocs, Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
        this.docs = new int[scoreDocs.length];
        this.scores = new float[scoreDocs.length];
        float maxScore = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < scoreDocs.length; ++i) {
            this.docs[i] = scoreDocs[i].doc;
            this.scores[i] = scoreDocs[i].score;
            maxScore = Math.max(maxScore, this.scores[i]);
        }
        this.maxScore = maxScore;
        this.segmentStarts = KnnScoreDocQuery.findSegmentStarts(reader, this.docs);
        this.contextIdentity = reader.getContext().id();
    }

    private static int[] findSegmentStarts(IndexReader reader, int[] docs) {
        int[] starts = new int[reader.leaves().size() + 1];
        starts[starts.length - 1] = docs.length;
        if (starts.length == 2) {
            return starts;
        }
        int resultIndex = 0;
        for (int i = 1; i < starts.length - 1; ++i) {
            int upper = ((LeafReaderContext)reader.leaves().get((int)i)).docBase;
            if ((resultIndex = Arrays.binarySearch(docs, resultIndex, docs.length, upper)) < 0) {
                resultIndex = -1 - resultIndex;
            }
            starts[i] = resultIndex;
        }
        return starts;
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        if (this.docs.length == 0) {
            return new MatchNoDocsQuery();
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (searcher.getIndexReader().getContext().id() != this.contextIdentity) {
            throw new IllegalStateException("This KnnScoreDocQuery was created by a different reader");
        }
        return new Weight(this){

            public int count(LeafReaderContext context) {
                return KnnScoreDocQuery.this.segmentStarts[context.ord + 1] - KnnScoreDocQuery.this.segmentStarts[context.ord];
            }

            public Explanation explain(LeafReaderContext context, int doc) {
                int found = Arrays.binarySearch(KnnScoreDocQuery.this.docs, doc + context.docBase);
                if (found < 0) {
                    return Explanation.noMatch((String)"not in top k documents", (Explanation[])new Explanation[0]);
                }
                return Explanation.match((Number)Float.valueOf(KnnScoreDocQuery.this.scores[found] * boost), (String)"within top k documents", (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(final LeafReaderContext context) {
                if (KnnScoreDocQuery.this.segmentStarts[context.ord] == KnnScoreDocQuery.this.segmentStarts[context.ord + 1]) {
                    return null;
                }
                return new Scorer(this){
                    final int lower;
                    final int upper;
                    int upTo;
                    {
                        super(arg0);
                        this.lower = KnnScoreDocQuery.this.segmentStarts[context.ord];
                        this.upper = KnnScoreDocQuery.this.segmentStarts[context.ord + 1];
                        this.upTo = -1;
                    }

                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){

                            public int docID() {
                                return this.currentDocId();
                            }

                            public int nextDoc() {
                                upTo = upTo == -1 ? lower : ++upTo;
                                return this.currentDocId();
                            }

                            public int advance(int target) throws IOException {
                                return this.slowAdvance(target);
                            }

                            public long cost() {
                                return upper - lower;
                            }
                        };
                    }

                    public float getMaxScore(int docId) {
                        return KnnScoreDocQuery.this.maxScore * boost;
                    }

                    public float score() {
                        return KnnScoreDocQuery.this.scores[this.upTo] * boost;
                    }

                    public int docID() {
                        return this.currentDocId();
                    }

                    private int currentDocId() {
                        if (this.upTo == -1) {
                            return -1;
                        }
                        if (this.upTo >= this.upper) {
                            return Integer.MAX_VALUE;
                        }
                        return KnnScoreDocQuery.this.docs[this.upTo] - context.docBase;
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    int[] docs() {
        return this.docs;
    }

    float[] scores() {
        return this.scores;
    }

    public String toString(String field) {
        return "DocAndScoreQuery[" + this.docs[0] + ",...][" + this.scores[0] + ",...]," + this.maxScore;
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        return Arrays.equals(this.docs, ((KnnScoreDocQuery)((Object)obj)).docs) && Arrays.equals(this.scores, ((KnnScoreDocQuery)((Object)obj)).scores) && Arrays.equals(this.segmentStarts, ((KnnScoreDocQuery)((Object)obj)).segmentStarts) && this.contextIdentity == ((KnnScoreDocQuery)((Object)obj)).contextIdentity;
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), Arrays.hashCode(this.docs), Arrays.hashCode(this.scores), Arrays.hashCode(this.segmentStarts), this.contextIdentity);
    }
}

