/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.stats.IndexingPressureStats;

public class IndexingPressure {
    public static final Setting<ByteSizeValue> MAX_INDEXING_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.limit", "10%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_THRESHOLD = Setting.memorySizeSetting("indexing_pressure.memory.split_bulk_threshold", "8.5%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_COORDINATING_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.coordinating.limit", MAX_INDEXING_BYTES, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_PRIMARY_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.primary.limit", MAX_INDEXING_BYTES, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_REPLICA_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.replica.limit", s -> ByteSizeValue.ofBytes((long)((double)MAX_PRIMARY_BYTES.get((Settings)s).getBytes() * 1.5)).getStringRep(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_HIGH_WATERMARK = Setting.memorySizeSetting("indexing_pressure.memory.split_bulk.watermark.high", "7.5%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_HIGH_WATERMARK_SIZE = Setting.byteSizeSetting("indexing_pressure.memory.split_bulk.watermark.high.bulk_size", ByteSizeValue.ofMb(1L), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_LOW_WATERMARK = Setting.memorySizeSetting("indexing_pressure.memory.split_bulk.watermark.low", "5.0%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_LOW_WATERMARK_SIZE = Setting.byteSizeSetting("indexing_pressure.memory.split_bulk.watermark.low.bulk_size", ByteSizeValue.ofMb(4L), Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(IndexingPressure.class);
    private final AtomicLong currentCombinedCoordinatingAndPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong currentCoordinatingBytes = new AtomicLong(0L);
    private final AtomicLong currentPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong currentReplicaBytes = new AtomicLong(0L);
    private final AtomicLong currentCoordinatingOps = new AtomicLong(0L);
    private final AtomicLong currentPrimaryOps = new AtomicLong(0L);
    private final AtomicLong currentReplicaOps = new AtomicLong(0L);
    private final AtomicLong totalCombinedCoordinatingAndPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingBytes = new AtomicLong(0L);
    private final AtomicLong totalPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong totalReplicaBytes = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingOps = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingRequests = new AtomicLong(0L);
    private final AtomicLong totalPrimaryOps = new AtomicLong(0L);
    private final AtomicLong totalReplicaOps = new AtomicLong(0L);
    private final AtomicLong coordinatingRejections = new AtomicLong(0L);
    private final AtomicLong primaryRejections = new AtomicLong(0L);
    private final AtomicLong replicaRejections = new AtomicLong(0L);
    private final AtomicLong primaryDocumentRejections = new AtomicLong(0L);
    private final AtomicLong lowWaterMarkSplits = new AtomicLong(0L);
    private final AtomicLong highWaterMarkSplits = new AtomicLong(0L);
    private final long lowWatermark;
    private final long lowWatermarkSize;
    private final long highWatermark;
    private final long highWatermarkSize;
    private final long coordinatingLimit;
    private final long primaryLimit;
    private final long replicaLimit;

    public IndexingPressure(Settings settings) {
        this.lowWatermark = SPLIT_BULK_LOW_WATERMARK.get(settings).getBytes();
        this.lowWatermarkSize = SPLIT_BULK_LOW_WATERMARK_SIZE.get(settings).getBytes();
        this.highWatermark = SPLIT_BULK_HIGH_WATERMARK.get(settings).getBytes();
        this.highWatermarkSize = SPLIT_BULK_HIGH_WATERMARK_SIZE.get(settings).getBytes();
        this.coordinatingLimit = MAX_COORDINATING_BYTES.get(settings).getBytes();
        this.primaryLimit = MAX_PRIMARY_BYTES.get(settings).getBytes();
        this.replicaLimit = MAX_REPLICA_BYTES.get(settings).getBytes();
    }

    private static Releasable wrapReleasable(Releasable releasable) {
        AtomicBoolean called = new AtomicBoolean();
        return () -> {
            if (called.compareAndSet(false, true)) {
                releasable.close();
            } else {
                logger.error("IndexingPressure memory is adjusted twice", (Throwable)new IllegalStateException("Releasable is called twice"));
                assert (false) : "IndexingPressure is adjusted twice";
            }
        };
    }

    public Incremental startIncrementalCoordinating(int operations, long bytes, boolean forceExecution) {
        Incremental coordinating = new Incremental(forceExecution);
        coordinating.coordinating.increment(operations, bytes);
        return coordinating;
    }

    public Coordinating markCoordinatingOperationStarted(int operations, long bytes, boolean forceExecution) {
        Coordinating coordinating = this.createCoordinatingOperation(forceExecution);
        coordinating.increment(operations, bytes);
        return coordinating;
    }

    public Coordinating createCoordinatingOperation(boolean forceExecution) {
        return new Coordinating(forceExecution);
    }

    public Releasable markPrimaryOperationLocalToCoordinatingNodeStarted(int operations, long bytes) {
        this.currentPrimaryBytes.getAndAdd(bytes);
        this.currentPrimaryOps.getAndAdd(operations);
        this.totalPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryOps.getAndAdd(operations);
        return IndexingPressure.wrapReleasable(() -> {
            this.currentPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryOps.getAndAdd(-operations);
        });
    }

    public Releasable markPrimaryOperationStarted(int operations, long bytes, boolean forceExecution) {
        long combinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long replicaWriteBytes = this.currentReplicaBytes.get();
        long totalBytes = combinedBytes + replicaWriteBytes;
        if (!forceExecution && totalBytes > this.primaryLimit) {
            long bytesWithoutOperation = combinedBytes - bytes;
            long totalBytesWithoutOperation = totalBytes - bytes;
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.primaryRejections.getAndIncrement();
            this.primaryDocumentRejections.addAndGet(operations);
            throw new EsRejectedExecutionException("rejected execution of primary operation [coordinating_and_primary_bytes=" + bytesWithoutOperation + ", replica_bytes=" + replicaWriteBytes + ", all_bytes=" + totalBytesWithoutOperation + ", primary_operation_bytes=" + bytes + ", max_primary_bytes=" + this.primaryLimit + "]", false);
        }
        logger.trace(() -> Strings.format("adding [%d] primary operations and [%d] bytes", operations, bytes));
        this.currentPrimaryBytes.getAndAdd(bytes);
        this.currentPrimaryOps.getAndAdd(operations);
        this.totalCombinedCoordinatingAndPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryOps.getAndAdd(operations);
        return IndexingPressure.wrapReleasable(() -> {
            logger.trace(() -> Strings.format("removing [%d] primary operations and [%d] bytes", operations, bytes));
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryOps.getAndAdd(-operations);
        });
    }

    public Releasable markReplicaOperationStarted(int operations, long bytes, boolean forceExecution) {
        long replicaWriteBytes = this.currentReplicaBytes.addAndGet(bytes);
        if (!forceExecution && replicaWriteBytes > this.replicaLimit) {
            long replicaBytesWithoutOperation = replicaWriteBytes - bytes;
            this.currentReplicaBytes.getAndAdd(-bytes);
            this.replicaRejections.getAndIncrement();
            throw new EsRejectedExecutionException("rejected execution of replica operation [replica_bytes=" + replicaBytesWithoutOperation + ", replica_operation_bytes=" + bytes + ", max_replica_bytes=" + this.replicaLimit + "]", false);
        }
        this.currentReplicaOps.getAndAdd(operations);
        this.totalReplicaBytes.getAndAdd(bytes);
        this.totalReplicaOps.getAndAdd(operations);
        return IndexingPressure.wrapReleasable(() -> {
            this.currentReplicaBytes.getAndAdd(-bytes);
            this.currentReplicaOps.getAndAdd(-operations);
        });
    }

    public IndexingPressureStats stats() {
        return new IndexingPressureStats(this.totalCombinedCoordinatingAndPrimaryBytes.get(), this.totalCoordinatingBytes.get(), this.totalPrimaryBytes.get(), this.totalReplicaBytes.get(), this.currentCombinedCoordinatingAndPrimaryBytes.get(), this.currentCoordinatingBytes.get(), this.currentPrimaryBytes.get(), this.currentReplicaBytes.get(), this.coordinatingRejections.get(), this.primaryRejections.get(), this.replicaRejections.get(), this.coordinatingLimit, this.totalCoordinatingOps.get(), this.totalPrimaryOps.get(), this.totalReplicaOps.get(), this.currentCoordinatingOps.get(), this.currentPrimaryOps.get(), this.currentReplicaOps.get(), this.primaryDocumentRejections.get(), this.totalCoordinatingRequests.get(), this.lowWaterMarkSplits.get(), this.highWaterMarkSplits.get());
    }

    public class Incremental
    implements Releasable {
        private final AtomicBoolean closed = new AtomicBoolean();
        private final boolean forceExecution;
        private long currentUnparsedSize = 0L;
        private long totalParsedBytes = 0L;
        private Coordinating coordinating;

        public Incremental(boolean forceExecution) {
            this.forceExecution = forceExecution;
            this.coordinating = new Coordinating(forceExecution);
        }

        public long totalParsedBytes() {
            return this.totalParsedBytes;
        }

        public void incrementUnparsedBytes(long bytes) {
            assert (!this.closed.get());
            this.currentUnparsedSize += bytes;
        }

        public void transferUnparsedBytesToParsed(long bytes) {
            assert (!this.closed.get());
            assert (this.currentUnparsedSize >= bytes);
            this.currentUnparsedSize -= bytes;
            this.totalParsedBytes += bytes;
        }

        public void increment(int operations, long bytes) {
            this.coordinating.increment(operations, bytes);
        }

        public long currentOperationsSize() {
            return this.coordinating.currentOperationsSize;
        }

        public Optional<Releasable> maybeSplit() {
            long currentUsage = IndexingPressure.this.currentCombinedCoordinatingAndPrimaryBytes.get() + IndexingPressure.this.currentReplicaBytes.get();
            long currentOperationsSize = this.coordinating.currentOperationsSize;
            if (currentUsage >= IndexingPressure.this.highWatermark && currentOperationsSize >= IndexingPressure.this.highWatermarkSize) {
                IndexingPressure.this.highWaterMarkSplits.getAndIncrement();
                logger.trace(() -> Strings.format("Split bulk due to high watermark: current bytes [%d] and size [%d]", currentUsage, currentOperationsSize));
                return Optional.of(this.split());
            }
            if (currentUsage >= IndexingPressure.this.lowWatermark && currentOperationsSize >= IndexingPressure.this.lowWatermarkSize) {
                IndexingPressure.this.lowWaterMarkSplits.getAndIncrement();
                logger.trace(() -> Strings.format("Split bulk due to low watermark: current bytes [%d] and size [%d]", currentUsage, currentOperationsSize));
                return Optional.of(this.split());
            }
            return Optional.empty();
        }

        public Releasable split() {
            Coordinating toReturn = this.coordinating;
            this.coordinating = new Coordinating(this.forceExecution);
            return toReturn;
        }

        public void close() {
            this.coordinating.close();
        }
    }

    public class Coordinating
    implements Releasable {
        private final AtomicBoolean closed = new AtomicBoolean();
        private final boolean forceExecution;
        private int currentOperations = 0;
        private long currentOperationsSize = 0L;

        public Coordinating(boolean forceExecution) {
            this.forceExecution = forceExecution;
        }

        public void increment(int operations, long bytes) {
            assert (!this.closed.get());
            long combinedBytes = IndexingPressure.this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
            long replicaWriteBytes = IndexingPressure.this.currentReplicaBytes.get();
            long totalBytes = combinedBytes + replicaWriteBytes;
            if (!this.forceExecution && totalBytes > IndexingPressure.this.coordinatingLimit) {
                long bytesWithoutOperation = combinedBytes - bytes;
                long totalBytesWithoutOperation = totalBytes - bytes;
                IndexingPressure.this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
                IndexingPressure.this.coordinatingRejections.getAndIncrement();
                throw new EsRejectedExecutionException("rejected execution of coordinating operation [coordinating_and_primary_bytes=" + bytesWithoutOperation + ", replica_bytes=" + replicaWriteBytes + ", all_bytes=" + totalBytesWithoutOperation + ", coordinating_operation_bytes=" + bytes + ", max_coordinating_bytes=" + IndexingPressure.this.coordinatingLimit + "]", false);
            }
            this.currentOperations += operations;
            this.currentOperationsSize += bytes;
            logger.trace(() -> Strings.format("adding [%d] coordinating operations and [%d] bytes", operations, bytes));
            IndexingPressure.this.currentCoordinatingBytes.getAndAdd(bytes);
            IndexingPressure.this.currentCoordinatingOps.getAndAdd(operations);
            IndexingPressure.this.totalCombinedCoordinatingAndPrimaryBytes.getAndAdd(bytes);
            IndexingPressure.this.totalCoordinatingBytes.getAndAdd(bytes);
            IndexingPressure.this.totalCoordinatingOps.getAndAdd(operations);
            IndexingPressure.this.totalCoordinatingRequests.getAndIncrement();
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                logger.trace(() -> Strings.format("removing [%d] coordinating operations and [%d] bytes", this.currentOperations, this.currentOperationsSize));
                IndexingPressure.this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-this.currentOperationsSize);
                IndexingPressure.this.currentCoordinatingBytes.getAndAdd(-this.currentOperationsSize);
                IndexingPressure.this.currentCoordinatingOps.getAndAdd(-this.currentOperations);
                this.currentOperationsSize = 0L;
                this.currentOperations = 0;
            } else {
                logger.error("IndexingPressure memory is adjusted twice", (Throwable)new IllegalStateException("Releasable is called twice"));
                assert (false) : "IndexingPressure is adjusted twice";
            }
        }
    }
}

