/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.xpack.esql.common.spatial.H3SphericalUtil;

public class GeoHexBoundedPredicate {
    private final boolean crossesDateline;
    private final GeoBoundingBox bbox;

    GeoHexBoundedPredicate(GeoBoundingBox bbox) {
        this.crossesDateline = bbox.right() < bbox.left();
        this.bbox = bbox;
    }

    public boolean validHex(long hex) {
        GeoBoundingBox scratch = new GeoBoundingBox(new GeoPoint(), new GeoPoint());
        H3SphericalUtil.computeGeoBounds(hex, scratch);
        if (this.bbox.top() > scratch.bottom() && this.bbox.bottom() < scratch.top()) {
            if (scratch.left() > scratch.right()) {
                return this.intersects(-180.0, scratch.right()) || this.intersects(scratch.left(), 180.0);
            }
            return this.intersects(scratch.left(), scratch.right());
        }
        return false;
    }

    private boolean intersects(double minLon, double maxLon) {
        if (this.crossesDateline) {
            return this.bbox.left() < maxLon || this.bbox.right() > minLon;
        }
        return this.bbox.left() < maxLon && this.bbox.right() > minLon;
    }
}

