/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.action.TimeSpan;

public class EsqlExecutionInfo
implements ChunkedToXContentObject,
Writeable {
    public static final String LOCAL_CLUSTER_NAME_REPRESENTATION = "(local)";
    public static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    public static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    public static final ParseField SKIPPED_FIELD = new ParseField("skipped", new String[0]);
    public static final ParseField RUNNING_FIELD = new ParseField("running", new String[0]);
    public static final ParseField PARTIAL_FIELD = new ParseField("partial", new String[0]);
    public static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    public static final ParseField DETAILS_FIELD = new ParseField("details", new String[0]);
    public static final ParseField TOOK = new ParseField("took", new String[0]);
    public static final ParseField IS_PARTIAL_FIELD = new ParseField("is_partial", new String[0]);
    private static final TransportVersion ESQL_QUERY_PLANNING_DURATION = TransportVersion.fromName((String)"esql_query_planning_duration");
    public final Map<String, Cluster> clusterInfo;
    private final boolean includeCCSMetadata;
    private final transient Predicate<String> skipUnavailablePredicate;
    private volatile boolean isPartial;
    private volatile transient boolean isStopped;
    private final transient TimeSpan.Builder relativeStart;
    private transient TimeSpan overallTimeSpan;
    private transient TimeSpan planningTimeSpan;
    private TimeValue overallTook;

    public EsqlExecutionInfo(boolean includeCCSMetadata) {
        this(Predicates.always(), includeCCSMetadata);
    }

    public EsqlExecutionInfo(Predicate<String> skipUnavailablePredicate, boolean includeCCSMetadata) {
        this.clusterInfo = ConcurrentCollections.newConcurrentMap();
        this.skipUnavailablePredicate = skipUnavailablePredicate;
        this.includeCCSMetadata = includeCCSMetadata;
        this.relativeStart = TimeSpan.start();
    }

    EsqlExecutionInfo(ConcurrentMap<String, Cluster> clusterInfo, boolean includeCCSMetadata) {
        this.clusterInfo = clusterInfo;
        this.includeCCSMetadata = includeCCSMetadata;
        this.skipUnavailablePredicate = Predicates.always();
        this.relativeStart = null;
    }

    public EsqlExecutionInfo(StreamInput in) throws IOException {
        this.overallTook = in.readOptionalTimeValue();
        List clusterList = in.readCollectionAsList(Cluster::new);
        if (clusterList.isEmpty()) {
            this.clusterInfo = ConcurrentCollections.newConcurrentMap();
        } else {
            ConcurrentMap m = ConcurrentCollections.newConcurrentMap();
            clusterList.forEach(c -> m.put(c.getClusterAlias(), c));
            this.clusterInfo = m;
        }
        this.includeCCSMetadata = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? in.readBoolean() : false;
        this.isPartial = in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? in.readBoolean() : false;
        this.skipUnavailablePredicate = Predicates.always();
        this.relativeStart = null;
        if (in.getTransportVersion().supports(ESQL_QUERY_PLANNING_DURATION)) {
            this.overallTimeSpan = (TimeSpan)in.readOptional(TimeSpan::readFrom);
            this.planningTimeSpan = (TimeSpan)in.readOptional(TimeSpan::readFrom);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalTimeValue(this.overallTook);
        if (this.clusterInfo != null) {
            out.writeCollection(this.clusterInfo.values().stream().toList());
        } else {
            out.writeCollection(Collections.emptyList());
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeBoolean(this.includeCCSMetadata);
        }
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeBoolean(this.isPartial);
        }
        if (out.getTransportVersion().supports(ESQL_QUERY_PLANNING_DURATION)) {
            out.writeOptionalWriteable((Writeable)this.overallTimeSpan);
            out.writeOptionalWriteable((Writeable)this.planningTimeSpan);
        }
    }

    public boolean includeCCSMetadata() {
        return this.includeCCSMetadata;
    }

    public void markEndPlanning() {
        assert (this.planningTimeSpan == null) : "markEndPlanning should only be called once";
        assert (this.relativeStart != null) : "Relative start time must be set when markEndPlanning is called";
        this.planningTimeSpan = this.relativeStart.stop();
    }

    public TimeValue planningTookTime() {
        return this.planningTimeSpan != null ? this.planningTimeSpan.toTimeValue() : null;
    }

    public void markEndQuery() {
        assert (this.relativeStart != null) : "Relative start time must be set when markEndQuery is called";
        this.overallTimeSpan = this.relativeStart.stop();
        this.overallTook = this.overallTimeSpan.toTimeValue();
    }

    void overallTook(TimeValue took) {
        this.overallTook = took;
    }

    public TimeValue overallTook() {
        return this.overallTook;
    }

    public TimeValue tookSoFar() {
        return this.relativeStart != null ? this.relativeStart.stop().toTimeValue() : TimeValue.ZERO;
    }

    public TimeSpan overallTimeSpan() {
        return this.overallTimeSpan;
    }

    public TimeSpan planningTimeSpan() {
        return this.planningTimeSpan;
    }

    public Set<String> clusterAliases() {
        return this.clusterInfo.keySet();
    }

    public boolean isSkipUnavailable(String clusterAlias) {
        if ("".equals(clusterAlias)) {
            return false;
        }
        return this.skipUnavailablePredicate.test(clusterAlias);
    }

    public boolean isCrossClusterSearch() {
        return this.clusterInfo.size() > 1 || this.clusterInfo.size() == 1 && !this.clusterInfo.containsKey("");
    }

    public boolean hasMetadataToReport() {
        return this.isCrossClusterSearch() && this.includeCCSMetadata || this.isPartial && this.clusterInfo.values().stream().anyMatch(c -> !c.getFailures().isEmpty());
    }

    public Cluster getCluster(String clusterAlias) {
        return this.clusterInfo.get(clusterAlias);
    }

    public Map<String, Cluster> getClusters() {
        return this.clusterInfo;
    }

    public Cluster swapCluster(String clusterAlias, BiFunction<String, Cluster, Cluster> remappingFunction) {
        return this.clusterInfo.compute(clusterAlias, (unused, oldCluster) -> {
            Cluster newCluster = (Cluster)remappingFunction.apply(clusterAlias, (Cluster)oldCluster);
            if (newCluster != null && !this.isPartial) {
                this.isPartial = newCluster.isPartial();
            }
            return newCluster;
        });
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        if (this.clusterInfo.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (!this.includeCCSMetadata) {
            return this.onlyFailuresToXContent(params);
        }
        return ChunkedToXContent.builder((ToXContent.Params)params).object(b -> {
            b.field(TOTAL_FIELD.getPreferredName(), this.clusterInfo.size());
            b.field(SUCCESSFUL_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.SUCCESSFUL));
            b.field(RUNNING_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.RUNNING));
            b.field(SKIPPED_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.SKIPPED));
            b.field(PARTIAL_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.PARTIAL));
            b.field(FAILED_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.FAILED));
            b.xContentObject("details", this.clusterInfo.values().iterator());
        });
    }

    private Iterator<? extends ToXContent> onlyFailuresToXContent(ToXContent.Params params) {
        Iterator failuresIterator = this.clusterInfo.values().stream().filter(c -> !c.getFailures().isEmpty()).iterator();
        if (failuresIterator.hasNext()) {
            return ChunkedToXContent.builder((ToXContent.Params)params).object(b -> b.xContentObject("details", failuresIterator));
        }
        return Collections.emptyIterator();
    }

    public int getClusterStateCount(Cluster.Status status) {
        assert (this.clusterInfo.size() > 0) : "ClusterMap in EsqlExecutionInfo must not be empty";
        return (int)this.clusterInfo.values().stream().filter(cluster -> cluster.getStatus() == status).count();
    }

    public Stream<Cluster> getClusterStates(Cluster.Status status) {
        assert (!this.clusterInfo.isEmpty()) : "ClusterMap in EsqlExecutionInfo must not be empty";
        return this.clusterInfo.values().stream().filter(cluster -> cluster.getStatus() == status);
    }

    public String toString() {
        return "EsqlExecutionInfo{overallTook=" + String.valueOf(this.overallTook) + ", isPartial=" + this.isPartial + ", isStopped=" + this.isStopped + ", clusterInfo=" + String.valueOf(this.clusterInfo) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsqlExecutionInfo that = (EsqlExecutionInfo)o;
        return Objects.equals(this.clusterInfo, that.clusterInfo) && Objects.equals(this.overallTook, that.overallTook);
    }

    public int hashCode() {
        return Objects.hash(this.clusterInfo, this.overallTook);
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public void markAsStopped() {
        this.isStopped = true;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public static class Cluster
    implements ToXContentFragment,
    Writeable {
        public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
        public static final ParseField TOOK = new ParseField("took", new String[0]);
        private final String clusterAlias;
        private final String indexExpression;
        private final boolean skipUnavailable;
        private final Status status;
        private final Integer totalShards;
        private final Integer successfulShards;
        private final Integer skippedShards;
        private final Integer failedShards;
        private final List<ShardSearchFailure> failures;
        private final TimeValue took;

        public Cluster(String clusterAlias, String indexExpression) {
            this(clusterAlias, indexExpression, true, Status.RUNNING, null, null, null, null, null, null);
        }

        public Cluster(String clusterAlias, String indexExpression, boolean skipUnavailable) {
            this(clusterAlias, indexExpression, skipUnavailable, Status.RUNNING, null, null, null, null, null, null);
        }

        public Cluster(String clusterAlias, String indexExpression, boolean skipUnavailable, Status status) {
            this(clusterAlias, indexExpression, skipUnavailable, status, null, null, null, null, null, null);
        }

        public Cluster(String clusterAlias, String indexExpression, boolean skipUnavailable, Status status, Integer totalShards, Integer successfulShards, Integer skippedShards, Integer failedShards, List<ShardSearchFailure> failures, TimeValue took) {
            assert (clusterAlias != null) : "clusterAlias cannot be null";
            assert (indexExpression != null) : "indexExpression of Cluster cannot be null";
            assert (status != null) : "status of Cluster cannot be null";
            this.clusterAlias = clusterAlias;
            this.indexExpression = indexExpression;
            this.skipUnavailable = skipUnavailable;
            this.status = status;
            this.totalShards = totalShards;
            this.successfulShards = successfulShards;
            this.skippedShards = skippedShards;
            this.failedShards = failedShards;
            this.failures = failures == null ? Collections.emptyList() : failures;
            this.took = took;
        }

        public Cluster(StreamInput in) throws IOException {
            this.clusterAlias = in.readString();
            this.indexExpression = in.readString();
            this.status = Status.valueOf(in.readString().toUpperCase(Locale.ROOT));
            this.totalShards = in.readOptionalInt();
            this.successfulShards = in.readOptionalInt();
            this.skippedShards = in.readOptionalInt();
            this.failedShards = in.readOptionalInt();
            this.took = in.readOptionalTimeValue();
            this.skipUnavailable = in.readBoolean();
            this.failures = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_CCS_EXEC_INFO_WITH_FAILURES) ? Collections.unmodifiableList(in.readCollectionAsList(ShardSearchFailure::readShardSearchFailure)) : Collections.emptyList();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterAlias);
            out.writeString(this.indexExpression);
            out.writeString(this.status.toString());
            out.writeOptionalInt(this.totalShards);
            out.writeOptionalInt(this.successfulShards);
            out.writeOptionalInt(this.skippedShards);
            out.writeOptionalInt(this.failedShards);
            out.writeOptionalTimeValue(this.took);
            out.writeBoolean(this.skipUnavailable);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_CCS_EXEC_INFO_WITH_FAILURES)) {
                out.writeCollection(this.failures);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String name = this.clusterAlias;
            if (this.clusterAlias.equals("")) {
                name = EsqlExecutionInfo.LOCAL_CLUSTER_NAME_REPRESENTATION;
            }
            builder.startObject(name);
            builder.field(STATUS_FIELD.getPreferredName(), this.getStatus().toString());
            builder.field(INDICES_FIELD.getPreferredName(), this.indexExpression);
            if (this.took != null && this.status != Status.RUNNING) {
                builder.field(TOOK.getPreferredName(), this.took.millis());
            }
            if (this.totalShards != null) {
                builder.startObject(RestActions._SHARDS_FIELD.getPreferredName());
                builder.field(RestActions.TOTAL_FIELD.getPreferredName(), this.totalShards);
                if (this.successfulShards != null) {
                    builder.field(RestActions.SUCCESSFUL_FIELD.getPreferredName(), this.successfulShards);
                }
                if (this.skippedShards != null) {
                    builder.field(RestActions.SKIPPED_FIELD.getPreferredName(), this.skippedShards);
                }
                if (this.failedShards != null) {
                    builder.field(RestActions.FAILED_FIELD.getPreferredName(), this.failedShards);
                }
                builder.endObject();
            }
            if (this.failures != null && this.failures.size() > 0) {
                builder.startArray(RestActions.FAILURES_FIELD.getPreferredName());
                for (ShardSearchFailure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public boolean isFragment() {
            return super.isFragment();
        }

        public String getClusterAlias() {
            return this.clusterAlias;
        }

        public String getIndexExpression() {
            return this.indexExpression;
        }

        public boolean isSkipUnavailable() {
            return this.skipUnavailable;
        }

        public Status getStatus() {
            return this.status;
        }

        public TimeValue getTook() {
            return this.took;
        }

        public Integer getTotalShards() {
            return this.totalShards;
        }

        public Integer getSuccessfulShards() {
            return this.successfulShards;
        }

        public Integer getSkippedShards() {
            return this.skippedShards;
        }

        public Integer getFailedShards() {
            return this.failedShards;
        }

        public List<ShardSearchFailure> getFailures() {
            return this.failures;
        }

        boolean isPartial() {
            return this.status == Status.PARTIAL || this.status == Status.SKIPPED || this.failedShards != null && this.failedShards > 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cluster cluster = (Cluster)o;
            return Objects.equals(this.clusterAlias, cluster.clusterAlias) && Objects.equals(this.indexExpression, cluster.indexExpression) && this.status == cluster.status && Objects.equals(this.totalShards, cluster.totalShards) && Objects.equals(this.successfulShards, cluster.successfulShards) && Objects.equals(this.skippedShards, cluster.skippedShards) && Objects.equals(this.failedShards, cluster.failedShards) && Objects.equals(this.took, cluster.took);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.clusterAlias, this.indexExpression, this.status, this.totalShards, this.successfulShards, this.skippedShards, this.failedShards, this.took});
        }

        public String toString() {
            return "Cluster{alias='" + this.clusterAlias + "', status=" + String.valueOf((Object)this.status) + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", skippedShards=" + this.skippedShards + ", failedShards=" + this.failedShards + ", took=" + String.valueOf(this.took) + ", indexExpression='" + this.indexExpression + "', skipUnavailable=" + this.skipUnavailable + "}";
        }

        public static enum Status {
            RUNNING,
            SUCCESSFUL,
            PARTIAL,
            SKIPPED,
            FAILED;


            public String toString() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }

        public static class Builder {
            private Status status;
            private Integer totalShards;
            private Integer successfulShards;
            private Integer skippedShards;
            private Integer failedShards;
            private List<ShardSearchFailure> failures;
            private TimeValue took;
            private final Cluster original;

            public Builder(Cluster copyFrom) {
                this.original = copyFrom;
            }

            public Cluster build() {
                return new Cluster(this.original.getClusterAlias(), this.original.getIndexExpression(), this.original.isSkipUnavailable(), this.status != null ? this.status : this.original.getStatus(), this.totalShards != null ? this.totalShards : this.original.getTotalShards(), this.successfulShards != null ? this.successfulShards : this.original.getSuccessfulShards(), this.skippedShards != null ? this.skippedShards : this.original.getSkippedShards(), this.failedShards != null ? this.failedShards : this.original.getFailedShards(), this.failures != null ? this.failures : this.original.getFailures(), this.took != null ? this.took : this.original.getTook());
            }

            public Builder setStatus(Status status) {
                this.status = status;
                return this;
            }

            public Builder setTotalShards(int totalShards) {
                this.totalShards = totalShards;
                return this;
            }

            public Builder setSuccessfulShards(int successfulShards) {
                this.successfulShards = successfulShards;
                return this;
            }

            public Builder setSkippedShards(int skippedShards) {
                this.skippedShards = skippedShards;
                return this;
            }

            public Builder setFailedShards(int failedShards) {
                this.failedShards = failedShards;
                return this;
            }

            public Builder addFailures(List<ShardSearchFailure> failures) {
                if (failures.isEmpty()) {
                    return this;
                }
                if (this.failures == null) {
                    this.failures = new ArrayList<ShardSearchFailure>(this.original.failures);
                }
                this.failures.addAll(failures);
                return this;
            }

            public Builder setTook(TimeValue took) {
                this.took = took;
                return this;
            }
        }
    }
}

