/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.function.IntConsumer;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class MultiBucketConsumerService {
    public static final int DEFAULT_MAX_BUCKETS = 65536;
    public static final Setting<Integer> MAX_BUCKET_SETTING = Setting.intSetting("search.max_buckets", 65536, 0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final CircuitBreaker breaker;
    private volatile int maxBucket;

    public MultiBucketConsumerService(ClusterService clusterService, Settings settings, CircuitBreaker breaker) {
        this.breaker = breaker;
        this.maxBucket = MAX_BUCKET_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_BUCKET_SETTING, this::setMaxBucket);
    }

    private void setMaxBucket(int maxBucket) {
        this.maxBucket = maxBucket;
    }

    public IntConsumer createForFinal() {
        return new MultiBucketConsumer(this.maxBucket, this.breaker);
    }

    public IntConsumer createForPartial() {
        return new MultiBucketConsumerPartialReduction(this.breaker);
    }

    public int getLimit() {
        return this.maxBucket;
    }

    public static class MultiBucketConsumer
    implements IntConsumer {
        private static final Logger logger = LogManager.getLogger(MultiBucketConsumer.class);
        private final int limit;
        private final CircuitBreaker breaker;
        private int count;
        private int callCount = 0;

        public MultiBucketConsumer(int limit, CircuitBreaker breaker) {
            this.limit = limit;
            this.breaker = breaker;
        }

        @Override
        public void accept(int value) {
            if (value != 0) {
                this.count += value;
                if (this.count > this.limit) {
                    logger.warn("Too many buckets (max [{}], count [{}])", new Object[]{this.limit, this.count});
                    throw new TooManyBucketsException("Trying to create too many buckets. Must be less than or equal to: [" + this.limit + "] but this number of buckets was exceeded. This limit can be set by changing the [" + MAX_BUCKET_SETTING.getKey() + "] cluster level setting.", this.limit);
                }
            }
            ++this.callCount;
            if ((this.callCount & 0x3FF) == 0) {
                this.breaker.addEstimateBytesAndMaybeBreak(0L, "allocated_buckets");
            }
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class MultiBucketConsumerPartialReduction
    implements IntConsumer {
        private final CircuitBreaker breaker;
        private int callCount = 0;

        private MultiBucketConsumerPartialReduction(CircuitBreaker breaker) {
            this.breaker = breaker;
        }

        @Override
        public void accept(int value) {
            if ((++this.callCount & 0x3FF) == 0) {
                this.breaker.addEstimateBytesAndMaybeBreak(0L, "allocated_buckets");
            }
        }
    }

    public static class TooManyBucketsException
    extends AggregationExecutionException {
        private final int maxBuckets;

        public TooManyBucketsException(String message, int maxBuckets) {
            super(message);
            this.maxBuckets = maxBuckets;
        }

        public TooManyBucketsException(StreamInput in) throws IOException {
            super(in);
            this.maxBuckets = in.readInt();
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
            super.writeTo(out, nestedExceptionsWriter);
            out.writeInt(this.maxBuckets);
        }

        public int getMaxBuckets() {
            return this.maxBuckets;
        }

        @Override
        public RestStatus status() {
            return RestStatus.BAD_REQUEST;
        }

        @Override
        protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("max_buckets", this.maxBuckets);
        }
    }
}

