/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;

public abstract class GeoPointFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = GeoPointFieldScript.newContext("geo_point_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup, OnScriptError onScriptError) {
            return ctx -> new GeoPointFieldScript(field, params, lookup, OnScriptError.FAIL, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private double[] lats = new double[1];
    private double[] lons = new double[1];
    private int count;

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup, onScriptError) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new GeoPointFieldScript(leafFieldName, params, searchLookup, onScriptError, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public GeoPointFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx, onScriptError);
    }

    @Override
    protected void prepareExecute() {
        this.count = 0;
    }

    public final void runForDoc(int docId, Consumer<GeoPoint> consumer) {
        this.runForDoc(docId);
        GeoPoint point = new GeoPoint();
        for (int i = 0; i < this.count; ++i) {
            point.reset(this.lats[i], this.lons[i]);
            consumer.accept(point);
        }
    }

    public final double[] lats() {
        return this.lats;
    }

    public final double[] lons() {
        return this.lons;
    }

    public final int count() {
        return this.count;
    }

    @Override
    protected List<Object> extractFromSource(String path) {
        Object value = XContentMapValues.extractValue(path, ((Source)this.source.get()).source());
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() > 0 && list.get(0) instanceof Number) {
                return Collections.singletonList(list);
            }
            return list;
        }
        return Collections.singletonList(value);
    }

    @Override
    protected void emitFromObject(Object value) {
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() > 0 && values.get(0) instanceof Number) {
                this.emitPoint(value);
            } else {
                for (Object point : values) {
                    this.emitPoint(point);
                }
            }
        } else {
            this.emitPoint(value);
        }
    }

    private void emitPoint(Object point) {
        if (point != null) {
            try {
                GeoPoint geoPoint = GeoUtils.parseGeoPoint(point, true);
                this.emit(geoPoint.lat(), geoPoint.lon());
            }
            catch (Exception e) {
                this.emit(0.0, 0.0);
            }
        }
    }

    protected final void emit(double lat, double lon) {
        this.checkMaxSize(this.count);
        if (this.lats.length < this.count + 1) {
            this.lats = ArrayUtil.grow((double[])this.lats, (int)(this.count + 1));
            this.lons = ArrayUtil.growExact((double[])this.lons, (int)this.lats.length);
        }
        this.lats[this.count] = lat;
        this.lons[this.count++] = lon;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3, OnScriptError var4);
    }

    public static interface LeafFactory {
        public GeoPointFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final GeoPointFieldScript script;

        public Emit(GeoPointFieldScript script) {
            this.script = script;
        }

        public void emit(double lat, double lon) {
            this.script.checkMaxSize(this.script.count());
            this.script.emit(lat, lon);
        }
    }
}

