/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.CountOnlyQueryPhaseResultConsumer;
import org.elasticsearch.action.search.QueryPhaseResultConsumer;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchSortValues;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileResultsBuilder;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.sort.ShardDocSortField;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;

public final class SearchPhaseController {
    private static final Logger logger = LogManager.getLogger(SearchPhaseController.class);
    private final BiFunction<Supplier<Boolean>, AggregatorFactories.Builder, AggregationReduceContext.Builder> requestToAggReduceContextBuilder;

    public SearchPhaseController(BiFunction<Supplier<Boolean>, AggregatorFactories.Builder, AggregationReduceContext.Builder> requestToAggReduceContextBuilder) {
        this.requestToAggReduceContextBuilder = requestToAggReduceContextBuilder;
    }

    /*
     * WARNING - void declaration
     */
    static SortedTopDocs sortDocs(boolean ignoreFrom, Collection<TopDocs> topDocs, int from, int size, List<CompletionSuggestion> reducedCompletionSuggestions) {
        void var10_15;
        ScoreDoc[] mergedScoreDocs;
        if (topDocs.isEmpty() && reducedCompletionSuggestions.isEmpty()) {
            return SortedTopDocs.EMPTY;
        }
        TopDocs mergedTopDocs = SearchPhaseController.mergeTopDocs(topDocs, size, ignoreFrom ? 0 : from);
        ScoreDoc[] scoreDocs = mergedScoreDocs = mergedTopDocs == null ? Lucene.EMPTY_SCORE_DOCS : mergedTopDocs.scoreDocs;
        int numSuggestDocs = 0;
        if (!reducedCompletionSuggestions.isEmpty()) {
            for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                assert (completionSuggestion != null);
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
            scoreDocs = new ScoreDoc[mergedScoreDocs.length + numSuggestDocs];
            System.arraycopy(mergedScoreDocs, 0, scoreDocs, 0, mergedScoreDocs.length);
            int offset = mergedScoreDocs.length;
            for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                    scoreDocs[offset++] = option.getDoc();
                }
            }
        }
        boolean isSortedByField = false;
        Object var10_13 = null;
        String groupField = null;
        Object[] groupValues = null;
        if (mergedTopDocs instanceof TopFieldDocs) {
            TopFieldDocs fieldDocs = (TopFieldDocs)mergedTopDocs;
            SortField[] sortFieldArray = fieldDocs.fields;
            if (fieldDocs instanceof TopFieldGroups) {
                TopFieldGroups topFieldGroups = (TopFieldGroups)fieldDocs;
                isSortedByField = !(fieldDocs.fields.length == 1 && fieldDocs.fields[0].getType() == SortField.Type.SCORE);
                groupField = topFieldGroups.field;
                groupValues = topFieldGroups.groupValues;
            } else {
                isSortedByField = true;
            }
        }
        return new SortedTopDocs(scoreDocs, isSortedByField, (SortField[])var10_15, groupField, groupValues, numSuggestDocs);
    }

    static TopDocs mergeTopDocs(Collection<TopDocs> results, int topN, int from) {
        Object mergedTopDocs;
        List<TopDocs> topDocsList = results.stream().filter(Objects::nonNull).toList();
        if (topDocsList.isEmpty()) {
            return null;
        }
        TopDocs topDocs = (TopDocs)topDocsList.stream().findFirst().get();
        int numShards = results.size();
        if (numShards == 1 && from == 0) {
            return topDocs;
        }
        try {
            if (topDocs instanceof TopFieldGroups) {
                TopFieldGroups firstTopDocs = (TopFieldGroups)topDocs;
                Sort sort = SearchPhaseController.validateSameSortTypesAndMaybeRewrite(results, firstTopDocs.fields);
                TopFieldGroups[] shardTopDocs = topDocsList.toArray(new TopFieldGroups[0]);
                mergedTopDocs = TopFieldGroups.merge(sort, from, topN, shardTopDocs, false);
            } else if (topDocs instanceof TopFieldDocs) {
                TopFieldDocs firstTopDocs = (TopFieldDocs)topDocs;
                TopFieldDocs[] shardTopDocs = topDocsList.toArray(new TopFieldDocs[0]);
                Sort sort = SearchPhaseController.validateSameSortTypesAndMaybeRewrite(results, firstTopDocs.fields);
                mergedTopDocs = TopDocs.merge((Sort)sort, (int)from, (int)topN, (TopFieldDocs[])shardTopDocs);
            } else {
                TopDocs[] shardTopDocs = topDocsList.toArray(new TopDocs[0]);
                mergedTopDocs = TopDocs.merge((int)from, (int)topN, (TopDocs[])shardTopDocs);
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("Failed to merge top docs: ", (Throwable)e);
            throw e;
        }
        return mergedTopDocs;
    }

    private static Sort validateSameSortTypesAndMaybeRewrite(Collection<TopDocs> results, SortField[] firstSortFields) {
        Sort sort = new Sort(firstSortFields);
        if (results.size() < 2) {
            return sort;
        }
        SortField.Type[] firstTypes = null;
        boolean isFirstResult = true;
        HashSet<Integer> fieldIdsWithMixedIntAndLongSorts = new HashSet<Integer>();
        for (TopDocs topDocs : results) {
            int i;
            if (topDocs.scoreDocs == null || topDocs.scoreDocs.length == 0) continue;
            SortField[] curSortFields = ((TopFieldDocs)topDocs).fields;
            if (isFirstResult) {
                sort = new Sort(curSortFields);
                firstTypes = new SortField.Type[curSortFields.length];
                for (i = 0; i < curSortFields.length; ++i) {
                    firstTypes[i] = SearchPhaseController.getType(curSortFields[i]);
                    if (firstTypes[i] != SortField.Type.CUSTOM) continue;
                    return sort;
                }
                isFirstResult = false;
                continue;
            }
            for (i = 0; i < curSortFields.length; ++i) {
                SortField.Type curType = SearchPhaseController.getType(curSortFields[i]);
                if (curType == firstTypes[i]) continue;
                if (curType == SortField.Type.CUSTOM) {
                    return sort;
                }
                if (firstTypes[i] == SortField.Type.INT && curType == SortField.Type.LONG || firstTypes[i] == SortField.Type.LONG && curType == SortField.Type.INT) {
                    fieldIdsWithMixedIntAndLongSorts.add(i);
                    continue;
                }
                throw new IllegalArgumentException("Can't sort on field [" + curSortFields[i].getField() + "]; the field has incompatible sort types: [" + String.valueOf(firstTypes[i]) + "] and [" + String.valueOf(curType) + "] across shards!");
            }
        }
        if (fieldIdsWithMixedIntAndLongSorts.size() > 0) {
            sort = SearchPhaseController.rewriteSortAndResultsToLong(sort, results, fieldIdsWithMixedIntAndLongSorts);
        }
        return sort;
    }

    private static Sort rewriteSortAndResultsToLong(Sort sort, Collection<TopDocs> results, Set<Integer> fieldIdsWithMixedIntAndLongSorts) {
        SortField[] newSortFields = sort.getSort();
        for (int fieldIdx : fieldIdsWithMixedIntAndLongSorts) {
            for (TopDocs topDocs : results) {
                if (topDocs.scoreDocs == null || topDocs.scoreDocs.length == 0) continue;
                SortField[] sortFields = ((TopFieldDocs)topDocs).fields;
                if (SearchPhaseController.getType(sortFields[fieldIdx]) == SortField.Type.INT) {
                    for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                        FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                        fieldDoc.fields[fieldIdx] = ((Number)fieldDoc.fields[fieldIdx]).longValue();
                    }
                    continue;
                }
                newSortFields[fieldIdx] = sortFields[fieldIdx];
            }
        }
        return new Sort(newSortFields);
    }

    private static SortField.Type getType(SortField sortField) {
        if (sortField instanceof SortedNumericSortField) {
            SortedNumericSortField sf = (SortedNumericSortField)sortField;
            return sf.getNumericType();
        }
        if (sortField instanceof SortedSetSortField) {
            return SortField.Type.STRING;
        }
        FieldComparatorSource fieldComparatorSource = sortField.getComparatorSource();
        if (fieldComparatorSource instanceof IndexFieldData.XFieldComparatorSource) {
            IndexFieldData.XFieldComparatorSource cmp = (IndexFieldData.XFieldComparatorSource)fieldComparatorSource;
            return cmp.reducedType();
        }
        return sortField.getType();
    }

    static void setShardIndex(TopDocs topDocs, int shardIndex) {
        assert (topDocs.scoreDocs.length == 0 || topDocs.scoreDocs[0].shardIndex == -1) : "shardIndex is already set";
        for (ScoreDoc doc : topDocs.scoreDocs) {
            doc.shardIndex = shardIndex;
        }
    }

    public static ScoreDoc[] getLastEmittedDocPerShard(ReducedQueryPhase reducedQueryPhase, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        if (!reducedQueryPhase.isEmptyResult) {
            ScoreDoc[] sortedScoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            long size = Math.min(reducedQueryPhase.fetchHits, (long)reducedQueryPhase.size);
            size = Math.min((long)sortedScoreDocs.length, size);
            int sortedDocsIndex = 0;
            while ((long)sortedDocsIndex < size) {
                ScoreDoc scoreDoc;
                lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = sortedScoreDocs[sortedDocsIndex];
                ++sortedDocsIndex;
            }
        }
        return lastEmittedDocPerShard;
    }

    public static List<Integer>[] fillDocIdsToLoad(int numShards, ScoreDoc[] shardDocs) {
        List[] docIdsToLoad = new ArrayList[numShards];
        for (ScoreDoc shardDoc : shardDocs) {
            ArrayList<Integer> shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex];
            if (shardDocIdsToLoad == null) {
                shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex] = new ArrayList<Integer>();
            }
            shardDocIdsToLoad.add(shardDoc.doc);
        }
        return docIdsToLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchResponseSections merge(boolean ignoreFrom, ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArray) {
        if (reducedQueryPhase.isEmptyResult) {
            return SearchResponseSections.EMPTY_WITH_TOTAL_HITS;
        }
        List<? extends SearchPhaseResult> fetchResults = fetchResultsArray.asList();
        SearchHits hits = SearchPhaseController.getHits(reducedQueryPhase, ignoreFrom, fetchResultsArray);
        try {
            if (reducedQueryPhase.suggest != null && !fetchResults.isEmpty()) {
                SearchPhaseController.mergeSuggest(reducedQueryPhase, fetchResultsArray, hits.getHits().length, reducedQueryPhase.sortedTopDocs.scoreDocs);
            }
            SearchResponseSections res = reducedQueryPhase.buildResponse(hits, fetchResults);
            hits = null;
            SearchResponseSections searchResponseSections = res;
            return searchResponseSections;
        }
        finally {
            if (hits != null) {
                hits.decRef();
            }
        }
    }

    private static void mergeSuggest(ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArray, int currentOffset, ScoreDoc[] sortedDocs) {
        for (CompletionSuggestion suggestion : reducedQueryPhase.suggest.filter(CompletionSuggestion.class)) {
            List<CompletionSuggestion.Entry.Option> suggestionOptions = suggestion.getOptions();
            for (int scoreDocIndex = currentOffset; scoreDocIndex < currentOffset + suggestionOptions.size(); ++scoreDocIndex) {
                ScoreDoc shardDoc = sortedDocs[scoreDocIndex];
                SearchPhaseResult searchResultProvider = fetchResultsArray.get(shardDoc.shardIndex);
                if (searchResultProvider == null) continue;
                FetchSearchResult fetchResult = searchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit hit = fetchResult.hits().getHits()[index];
                CompletionSuggestion.Entry.Option suggestOption = suggestionOptions.get(scoreDocIndex - currentOffset);
                hit.score(shardDoc.score);
                hit.shard(fetchResult.getSearchShardTarget());
                suggestOption.setHit(hit);
            }
            currentOffset += suggestionOptions.size();
        }
        assert (currentOffset == sortedDocs.length) : "expected no more score doc slices";
    }

    private static SearchHits getHits(ReducedQueryPhase reducedQueryPhase, boolean ignoreFrom, AtomicArray<? extends SearchPhaseResult> fetchResultsArray) {
        SortedTopDocs sortedTopDocs = reducedQueryPhase.sortedTopDocs;
        int sortScoreIndex = -1;
        if (sortedTopDocs.isSortedByField) {
            SortField[] sortFields = sortedTopDocs.sortFields;
            for (int i = 0; i < sortFields.length; ++i) {
                if (sortFields[i].getType() != SortField.Type.SCORE) continue;
                sortScoreIndex = i;
            }
        }
        List<? extends SearchPhaseResult> fetchResults = fetchResultsArray.asList();
        for (SearchPhaseResult searchPhaseResult : fetchResults) {
            searchPhaseResult.fetchResult().initCounter();
        }
        int from = ignoreFrom ? 0 : reducedQueryPhase.from;
        int n2 = (int)Math.min(reducedQueryPhase.fetchHits - (long)from, (long)reducedQueryPhase.size);
        n2 = Math.min(sortedTopDocs.scoreDocs.length - sortedTopDocs.numberOfCompletionsSuggestions, n2);
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        if (!fetchResults.isEmpty()) {
            for (int i = 0; i < n2; ++i) {
                ScoreDoc shardDoc = sortedTopDocs.scoreDocs[i];
                SearchPhaseResult fetchResultProvider = fetchResultsArray.get(shardDoc.shardIndex);
                if (fetchResultProvider == null) continue;
                FetchSearchResult fetchResult = fetchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit searchHit = fetchResult.hits().getHits()[index];
                searchHit.shard(fetchResult.getSearchShardTarget());
                if (shardDoc instanceof RankDoc) {
                    searchHit.setRank(((RankDoc)shardDoc).rank);
                    searchHit.score(shardDoc.score);
                    long shardAndDoc = ShardDocSortField.encodeShardAndDoc(shardDoc.shardIndex, shardDoc.doc);
                    searchHit.sortValues(new SearchSortValues(new Object[]{Float.valueOf(shardDoc.score), shardAndDoc}, new DocValueFormat[]{DocValueFormat.RAW, DocValueFormat.RAW}));
                } else if (sortedTopDocs.isSortedByField) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields, reducedQueryPhase.sortValueFormats);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                } else {
                    searchHit.score(shardDoc.score);
                }
                hits.add(searchHit);
                searchHit.incRef();
            }
        }
        return new SearchHits(hits.toArray(SearchHits.EMPTY), reducedQueryPhase.totalHits, reducedQueryPhase.maxScore, sortedTopDocs.sortFields, sortedTopDocs.collapseField, sortedTopDocs.collapseValues);
    }

    static ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, @Nullable InternalAggregations reducedAggs, List<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int numReducePhases, boolean isScrollRequest, QueryPhaseRankCoordinatorContext queryPhaseRankCoordinatorContext) {
        SortedTopDocs sortedTopDocs;
        Suggest reducedSuggest;
        assert (numReducePhases >= 0) : "num reduce phases must be >= 0 but was: " + numReducePhases;
        ++numReducePhases;
        if (queryResults.isEmpty()) {
            return new ReducedQueryPhase(topDocsStats.getTotalHits(), topDocsStats.fetchHits, topDocsStats.getMaxScore(), false, null, null, null, null, SortedTopDocs.EMPTY, null, null, numReducePhases, 0, 0, true);
        }
        ArrayList<QuerySearchResult> nonNullResults = new ArrayList<QuerySearchResult>();
        boolean hasSuggest = false;
        boolean hasProfileResults = false;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            QuerySearchResult res = searchPhaseResult.queryResult();
            if (res.isNull()) continue;
            hasSuggest |= res.suggest() != null;
            hasProfileResults |= res.hasProfileResults();
            nonNullResults.add(res);
        }
        SearchPhaseController.validateMergeSortValueFormats(nonNullResults);
        if (nonNullResults.isEmpty()) {
            IllegalStateException ex = new IllegalStateException("must have at least one non-empty search result, got 0 out of " + queryResults.size());
            assert (false) : ex;
            throw ex;
        }
        HashMap groupedSuggestions = hasSuggest ? new HashMap() : Collections.emptyMap();
        Map<String, SearchProfileQueryPhaseResult> map = hasProfileResults ? Maps.newMapWithExpectedSize(nonNullResults.size()) : Collections.emptyMap();
        int from = 0;
        int size = 0;
        DocValueFormat[] sortValueFormats = null;
        for (QuerySearchResult result : nonNullResults) {
            from = result.from();
            size = Math.max(result.size(), size);
            if (result.sortValueFormats() != null) {
                sortValueFormats = result.sortValueFormats();
            }
            if (hasSuggest) {
                assert (result.suggest() != null);
                for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : result.suggest()) {
                    groupedSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList()).add(suggestion);
                    if (!(suggestion instanceof CompletionSuggestion)) continue;
                    CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggestion;
                    completionSuggestion.setShardIndex(result.getShardIndex());
                }
            }
            assert (bufferedTopDocs.isEmpty() || result.hasConsumedTopDocs()) : "firstResult has no aggs but we got non null buffered aggs?";
            if (!hasProfileResults) continue;
            map.put(result.getSearchShardTarget().toString(), result.consumeProfileResult());
        }
        Suggest suggest = reducedSuggest = groupedSuggestions.isEmpty() ? null : new Suggest(Suggest.reduce(groupedSuggestions));
        if (queryPhaseRankCoordinatorContext == null) {
            sortedTopDocs = SearchPhaseController.sortDocs(isScrollRequest, bufferedTopDocs, from, size, reducedSuggest == null ? Collections.emptyList() : reducedSuggest.filter(CompletionSuggestion.class));
        } else {
            sortedTopDocs = new SortedTopDocs(queryPhaseRankCoordinatorContext.rankQueryPhaseResults(nonNullResults, topDocsStats), false, null, null, null, 0);
            size = sortedTopDocs.scoreDocs.length;
            from = 0;
        }
        return new ReducedQueryPhase(topDocsStats.getTotalHits(), topDocsStats.fetchHits, topDocsStats.getMaxScore(), topDocsStats.timedOut, topDocsStats.terminatedEarly, reducedSuggest, reducedAggs, map.isEmpty() ? null : new SearchProfileResultsBuilder(map), sortedTopDocs, sortValueFormats, queryPhaseRankCoordinatorContext, numReducePhases, size, from, false);
    }

    private static void validateMergeSortValueFormats(Collection<? extends SearchPhaseResult> queryResults) {
        boolean[] ulFormats = null;
        boolean firstResult = true;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            int i;
            DocValueFormat[] formats = searchPhaseResult.queryResult().sortValueFormats();
            if (formats == null) {
                return;
            }
            if (firstResult) {
                firstResult = false;
                ulFormats = new boolean[formats.length];
                for (i = 0; i < formats.length; ++i) {
                    ulFormats[i] = formats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED;
                }
                continue;
            }
            for (i = 0; i < formats.length; ++i) {
                if (!(ulFormats[i] ^ formats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED)) continue;
                throw new IllegalArgumentException("Can't do sort across indices, as a field has [unsigned_long] type in one index, and different type in another index!");
            }
        }
    }

    static int getTopDocsSize(SearchRequest request) {
        if (request.source() == null) {
            return 10;
        }
        SearchSourceBuilder source = request.source();
        if (source.rankBuilder() != null) {
            return source.rankBuilder().rankWindowSize();
        }
        return (source.size() == -1 ? 10 : source.size()) + (source.from() == -1 ? 0 : source.from());
    }

    AggregationReduceContext.Builder getReduceContext(Supplier<Boolean> isCanceled, AggregatorFactories.Builder aggs) {
        return this.requestToAggReduceContextBuilder.apply(isCanceled, aggs);
    }

    SearchPhaseResults<SearchPhaseResult> newSearchPhaseResults(Executor executor, CircuitBreaker circuitBreaker, Supplier<Boolean> isCanceled, SearchProgressListener listener, SearchRequest request, int numShards, Consumer<Exception> onPartialMergeFailure) {
        int size;
        int n = size = request.source() == null || request.source().size() == -1 ? 10 : request.source().size();
        if (size == 0 && (request.source() == null || request.source().aggregations() == null && request.source().suggest() == null && request.source().rankBuilder() == null && request.source().knnSearch().isEmpty() && !request.source().profile()) && request.resolveTrackTotalHitsUpTo() == Integer.MAX_VALUE) {
            return new CountOnlyQueryPhaseResultConsumer(listener, numShards);
        }
        return new QueryPhaseResultConsumer(request, executor, circuitBreaker, this, isCanceled, listener, numShards, onPartialMergeFailure);
    }

    public record SortedTopDocs(ScoreDoc[] scoreDocs, boolean isSortedByField, SortField[] sortFields, String collapseField, Object[] collapseValues, int numberOfCompletionsSuggestions) {
        public static final SortedTopDocs EMPTY = new SortedTopDocs(Lucene.EMPTY_SCORE_DOCS, false, null, null, null, 0);
    }

    public record ReducedQueryPhase(TotalHits totalHits, long fetchHits, float maxScore, boolean timedOut, Boolean terminatedEarly, Suggest suggest, InternalAggregations aggregations, SearchProfileResultsBuilder profileBuilder, SortedTopDocs sortedTopDocs, DocValueFormat[] sortValueFormats, QueryPhaseRankCoordinatorContext queryPhaseRankCoordinatorContext, int numReducePhases, int size, int from, boolean isEmptyResult) {
        public ReducedQueryPhase {
            if (numReducePhases <= 0) {
                throw new IllegalArgumentException("at least one reduce phase must have been applied but was: " + numReducePhases);
            }
        }

        public SearchResponseSections buildResponse(SearchHits hits, Collection<? extends SearchPhaseResult> fetchResults) {
            return new SearchResponseSections(hits, this.aggregations, this.suggest, this.timedOut, this.terminatedEarly, this.buildSearchProfileResults(fetchResults), this.numReducePhases);
        }

        private SearchProfileResults buildSearchProfileResults(Collection<? extends SearchPhaseResult> fetchResults) {
            if (this.profileBuilder == null) {
                assert (fetchResults.stream().map(SearchPhaseResult::fetchResult).allMatch(r -> r == null || r.profileResult() == null)) : "found fetch profile without search profile";
                return null;
            }
            return this.profileBuilder.build(fetchResults);
        }
    }

    public static final class TopDocsStats
    implements Writeable {
        final int trackTotalHitsUpTo;
        long totalHits;
        private TotalHits.Relation totalHitsRelation;
        public long fetchHits;
        private float maxScore = Float.NEGATIVE_INFINITY;
        public boolean timedOut;
        public Boolean terminatedEarly;

        public TopDocsStats(int trackTotalHitsUpTo) {
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            this.totalHits = 0L;
            this.totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        }

        float getMaxScore() {
            return Float.isInfinite(this.maxScore) ? Float.NaN : this.maxScore;
        }

        TotalHits getTotalHits() {
            if (this.trackTotalHitsUpTo == -1) {
                return null;
            }
            if (this.trackTotalHitsUpTo == Integer.MAX_VALUE) {
                assert (this.totalHitsRelation == TotalHits.Relation.EQUAL_TO);
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            if (this.totalHits <= (long)this.trackTotalHitsUpTo) {
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            return new TotalHits((long)this.trackTotalHitsUpTo, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
        }

        void add(TopDocsStats other) {
            if (this.trackTotalHitsUpTo != -1) {
                this.totalHits += other.totalHits;
                if (other.totalHitsRelation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                }
            }
            this.fetchHits += other.fetchHits;
            if (!Float.isNaN(other.maxScore)) {
                this.maxScore = Math.max(this.maxScore, other.maxScore);
            }
            if (other.timedOut) {
                this.timedOut = true;
            }
            if (other.terminatedEarly != null) {
                if (this.terminatedEarly == null) {
                    this.terminatedEarly = other.terminatedEarly;
                } else if (this.terminatedEarly.booleanValue()) {
                    this.terminatedEarly = true;
                }
            }
        }

        void add(TopDocsAndMaxScore topDocs, boolean timedOut, Boolean terminatedEarly) {
            if (this.trackTotalHitsUpTo != -1) {
                this.totalHits += topDocs.topDocs.totalHits.value;
                if (topDocs.topDocs.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                }
            }
            this.fetchHits += (long)topDocs.topDocs.scoreDocs.length;
            if (!Float.isNaN(topDocs.maxScore)) {
                this.maxScore = Math.max(this.maxScore, topDocs.maxScore);
            }
            if (timedOut) {
                this.timedOut = true;
            }
            if (terminatedEarly != null) {
                if (this.terminatedEarly == null) {
                    this.terminatedEarly = terminatedEarly;
                } else if (terminatedEarly.booleanValue()) {
                    this.terminatedEarly = true;
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.trackTotalHitsUpTo);
            out.writeFloat(this.maxScore);
            Lucene.writeTotalHits(out, new TotalHits(this.totalHits, this.totalHitsRelation));
            out.writeVLong(this.fetchHits);
            out.writeFloat(this.maxScore);
            out.writeBoolean(this.timedOut);
            out.writeOptionalBoolean(this.terminatedEarly);
        }

        public static TopDocsStats readFrom(StreamInput in) throws IOException {
            TopDocsStats res = new TopDocsStats(in.readVInt());
            res.maxScore = in.readFloat();
            TotalHits totalHits = Lucene.readTotalHits(in);
            res.totalHits = totalHits.value;
            res.totalHitsRelation = totalHits.relation;
            res.fetchHits = in.readVLong();
            res.maxScore = in.readFloat();
            res.timedOut = in.readBoolean();
            res.terminatedEarly = in.readOptionalBoolean();
            return res;
        }
    }
}

