/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record RepositoryUsageStats(Map<String, Map<String, Long>> statsByType) implements Writeable,
ToXContentObject
{
    public static final RepositoryUsageStats EMPTY = new RepositoryUsageStats(Map.of());

    public static RepositoryUsageStats readFrom(StreamInput in) throws IOException {
        Map<String, Map<String, Long>> statsByType = in.readMap(i -> i.readMap(StreamInput::readVLong));
        if (statsByType.isEmpty()) {
            return EMPTY;
        }
        return new RepositoryUsageStats(statsByType);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.statsByType, (o, m) -> o.writeMap(m, StreamOutput::writeVLong));
    }

    public boolean isEmpty() {
        return this.statsByType.isEmpty();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, Map<String, Long>> typeAndStats : this.statsByType.entrySet()) {
            builder.startObject(typeAndStats.getKey());
            for (Map.Entry<String, Long> statAndValue : typeAndStats.getValue().entrySet()) {
                builder.field(statAndValue.getKey(), statAndValue.getValue());
            }
            builder.endObject();
        }
        return builder.endObject();
    }
}

