/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;

public class ActionUtils {
    public static ActionListener<InferenceServiceResults> wrapFailuresInElasticsearchException(String errorMessage, ActionListener<InferenceServiceResults> listener) {
        return listener.delegateResponse((l, e) -> {
            Throwable unwrappedException = ExceptionsHelper.unwrapCause((Throwable)e);
            if (unwrappedException instanceof ElasticsearchException) {
                ElasticsearchException esException = (ElasticsearchException)unwrappedException;
                l.onFailure((Exception)esException);
            } else {
                l.onFailure((Exception)ActionUtils.createInternalServerError(unwrappedException, Strings.format((String)"%s. Cause: %s", (Object[])new Object[]{errorMessage, unwrappedException.getMessage()})));
            }
        });
    }

    public static ElasticsearchStatusException createInternalServerError(Throwable e, String message) {
        return new ElasticsearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
    }

    public static String constructFailedToSendRequestMessage(String message) {
        return Strings.format((String)"Failed to send %s request", (Object[])new Object[]{message});
    }

    private ActionUtils() {
    }
}

