/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponse;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseChunk;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.StreamingXContentResponse;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

class RepositoryVerifyIntegrityResponseStream
extends AbstractRefCounted {
    private static final Logger logger = LogManager.getLogger(RepositoryVerifyIntegrityResponseStream.class);
    private final RestChannel restChannel;
    private final SubscribableListener<RepositoryVerifyIntegrityResponse> finalResultListener = new SubscribableListener();
    private final ActionListener<RepositoryVerifyIntegrityResponse> completionListener = ActionListener.assertOnce((ActionListener)ActionListener.releaseAfter(this.finalResultListener, () -> ((RepositoryVerifyIntegrityResponseStream)this).decRef()));
    @Nullable
    private StreamingXContentResponse streamingXContentResponse;
    private final AtomicLong anomalyCount = new AtomicLong();

    RepositoryVerifyIntegrityResponseStream(RestChannel restChannel) {
        this.restChannel = restChannel;
    }

    void startResponse(Releasable releasable) throws IOException {
        assert (this.hasReferences());
        assert (this.streamingXContentResponse == null);
        this.streamingXContentResponse = new StreamingXContentResponse(this.restChannel, (ToXContent.Params)this.restChannel.request(), () -> {});
        this.streamingXContentResponse.writeFragment(p0 -> ChunkedToXContentHelper.singleChunk((b, p) -> b.startObject().startArray("log")), releasable);
    }

    void writeChunk(RepositoryVerifyIntegrityResponseChunk chunk, Releasable releasable) {
        assert (this.hasReferences());
        assert (this.streamingXContentResponse != null);
        if (chunk.type() == RepositoryVerifyIntegrityResponseChunk.Type.ANOMALY) {
            this.anomalyCount.incrementAndGet();
        }
        this.streamingXContentResponse.writeFragment(p0 -> ChunkedToXContentHelper.singleChunk((b, p) -> b.startObject().value((ToXContent)chunk, p).endObject()), releasable);
    }

    protected void closeInternal() {
        try {
            assert (this.finalResultListener.isDone());
            this.finalResultListener.addListener((ActionListener)new ActionListener<RepositoryVerifyIntegrityResponse>(){

                public void onResponse(RepositoryVerifyIntegrityResponse repositoryVerifyIntegrityResponse) {
                    assert (RepositoryVerifyIntegrityResponseStream.this.streamingXContentResponse != null);
                    RepositoryVerifyIntegrityResponseStream.this.streamingXContentResponse.writeFragment(p0 -> ChunkedToXContentHelper.singleChunk((b, p) -> b.endArray().startObject("results").field("status", (ToXContent)repositoryVerifyIntegrityResponse.finalTaskStatus()).field("final_repository_generation", repositoryVerifyIntegrityResponse.finalRepositoryGeneration()).field("total_anomalies", RepositoryVerifyIntegrityResponseStream.this.anomalyCount.get()).field("result", RepositoryVerifyIntegrityResponseStream.this.anomalyCount.get() == 0L ? (repositoryVerifyIntegrityResponse.originalRepositoryGeneration() == repositoryVerifyIntegrityResponse.finalRepositoryGeneration() ? "pass" : "inconclusive due to concurrent writes") : "fail").endObject().endObject()), () -> {});
                }

                public void onFailure(Exception e) {
                    if (RepositoryVerifyIntegrityResponseStream.this.streamingXContentResponse != null) {
                        RepositoryVerifyIntegrityResponseStream.this.streamingXContentResponse.writeFragment(p0 -> ChunkedToXContentHelper.singleChunk((b, p) -> b.endArray().startObject("exception").value((bb, pp) -> ElasticsearchException.generateFailureXContent((XContentBuilder)bb, (ToXContent.Params)pp, (Exception)e, (boolean)true)).field("status", (Enum)ExceptionsHelper.status((Throwable)e)).endObject().endObject()), () -> {});
                    } else {
                        try {
                            RepositoryVerifyIntegrityResponseStream.this.restChannel.sendResponse(new RestResponse(RepositoryVerifyIntegrityResponseStream.this.restChannel, e));
                        }
                        catch (IOException e2) {
                            e.addSuppressed(e2);
                            logger.error("error building error response", (Throwable)e);
                            assert (false) : e;
                            RepositoryVerifyIntegrityResponseStream.this.restChannel.request().getHttpChannel().close();
                        }
                    }
                }
            });
        }
        finally {
            Releasables.closeExpectNoException((Releasable)this.streamingXContentResponse);
        }
    }

    public ActionListener<RepositoryVerifyIntegrityResponse> getCompletionListener() {
        return this.completionListener;
    }
}

