/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.options.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamOptionsAction {
    public static final ActionType<Response> INSTANCE = new ActionType("indices:admin/data_stream/options/get");

    private GetDataStreamOptionsAction() {
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamEntry> dataStreams;

        public Response(List<DataStreamEntry> dataStreams) {
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readCollectionAsList(DataStreamEntry::new));
        }

        public List<DataStreamEntry> getDataStreams() {
            return this.dataStreams;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreams);
        }

        public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> {
                builder.startObject();
                builder.startArray(DATA_STREAMS_FIELD.getPreferredName());
                return builder;
            }), Iterators.map(this.dataStreams.iterator(), entry -> (builder, params) -> entry.toXContent(builder, outerParams)), Iterators.single((builder, params) -> {
                builder.endArray();
                builder.endObject();
                return builder;
            })});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams);
        }

        public record DataStreamEntry(String dataStreamName, DataStreamOptions dataStreamOptions) implements Writeable,
        ToXContentObject
        {
            public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
            public static final ParseField OPTIONS_FIELD = new ParseField("options", new String[0]);

            DataStreamEntry(StreamInput in) throws IOException {
                this(in.readString(), (DataStreamOptions)in.readOptionalWriteable(DataStreamOptions::read));
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.dataStreamName);
                out.writeOptionalWriteable((Writeable)this.dataStreamOptions);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(NAME_FIELD.getPreferredName(), this.dataStreamName);
                if (this.dataStreamOptions != null && !this.dataStreamOptions.isEmpty()) {
                    builder.field(OPTIONS_FIELD.getPreferredName(), (ToXContent)this.dataStreamOptions);
                }
                builder.endObject();
                return builder;
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private static final TransportVersion DATA_STREAM_OPTIONS_API_REMOVE_INCLUDE_DEFAULTS = TransportVersion.fromName((String)"data_stream_options_api_remove_include_defaults");
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).allowEmptyExpressions(true).resolveAliases(false)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(true).allowSelectors(false)).build();

        public Request(TimeValue masterNodeTimeout, String[] names) {
            super(masterNodeTimeout);
            this.names = names;
        }

        public Request(TimeValue masterNodeTimeout, String[] names, boolean includeDefaults) {
            super(masterNodeTimeout);
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
            if (!in.getTransportVersion().supports(DATA_STREAM_OPTIONS_API_REMOVE_INCLUDE_DEFAULTS)) {
                in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            if (!out.getTransportVersion().supports(DATA_STREAM_OPTIONS_API_REMOVE_INCLUDE_DEFAULTS)) {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals((Object)request.indicesOptions);
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        public String[] indices() {
            return this.names;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }
    }
}

