/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.GeoLocation;
import com.microsoft.graph.models.security.Stream;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IpEvidence
extends AlertEvidence
implements Parsable {
    public IpEvidence() {
        this.setOdataType("#microsoft.graph.security.ipEvidence");
    }

    @Nonnull
    public static IpEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IpEvidence();
    }

    @Nullable
    public String getCountryLetterCode() {
        return (String)this.backingStore.get("countryLetterCode");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("countryLetterCode", n -> this.setCountryLetterCode(n.getStringValue()));
        deserializerMap.put("ipAddress", n -> this.setIpAddress(n.getStringValue()));
        deserializerMap.put("location", n -> this.setLocation((GeoLocation)n.getObjectValue(GeoLocation::createFromDiscriminatorValue)));
        deserializerMap.put("stream", n -> this.setStream((Stream)n.getObjectValue(Stream::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getIpAddress() {
        return (String)this.backingStore.get("ipAddress");
    }

    @Nullable
    public GeoLocation getLocation() {
        return (GeoLocation)this.backingStore.get("location");
    }

    @Nullable
    public Stream getStream() {
        return (Stream)this.backingStore.get("stream");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("countryLetterCode", this.getCountryLetterCode());
        writer.writeStringValue("ipAddress", this.getIpAddress());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeObjectValue("stream", (Parsable)this.getStream(), new Parsable[0]);
    }

    public void setCountryLetterCode(@Nullable String value) {
        this.backingStore.set("countryLetterCode", (Object)value);
    }

    public void setIpAddress(@Nullable String value) {
        this.backingStore.set("ipAddress", (Object)value);
    }

    public void setLocation(@Nullable GeoLocation value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setStream(@Nullable Stream value) {
        this.backingStore.set("stream", (Object)value);
    }
}

