/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ItemBody;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VirtualEventPresenterDetails
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public VirtualEventPresenterDetails() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static VirtualEventPresenterDetails createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new VirtualEventPresenterDetails();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public ItemBody getBio() {
        return (ItemBody)this.backingStore.get("bio");
    }

    @Nullable
    public String getCompany() {
        return (String)this.backingStore.get("company");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("bio", n -> this.setBio((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("company", n -> this.setCompany(n.getStringValue()));
        deserializerMap.put("jobTitle", n -> this.setJobTitle(n.getStringValue()));
        deserializerMap.put("linkedInProfileWebUrl", n -> this.setLinkedInProfileWebUrl(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("personalSiteWebUrl", n -> this.setPersonalSiteWebUrl(n.getStringValue()));
        deserializerMap.put("photo", n -> this.setPhoto(n.getByteArrayValue()));
        deserializerMap.put("twitterProfileWebUrl", n -> this.setTwitterProfileWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getJobTitle() {
        return (String)this.backingStore.get("jobTitle");
    }

    @Nullable
    public String getLinkedInProfileWebUrl() {
        return (String)this.backingStore.get("linkedInProfileWebUrl");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPersonalSiteWebUrl() {
        return (String)this.backingStore.get("personalSiteWebUrl");
    }

    @Nullable
    public byte[] getPhoto() {
        return (byte[])this.backingStore.get("photo");
    }

    @Nullable
    public String getTwitterProfileWebUrl() {
        return (String)this.backingStore.get("twitterProfileWebUrl");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("bio", (Parsable)this.getBio(), new Parsable[0]);
        writer.writeStringValue("company", this.getCompany());
        writer.writeStringValue("jobTitle", this.getJobTitle());
        writer.writeStringValue("linkedInProfileWebUrl", this.getLinkedInProfileWebUrl());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("personalSiteWebUrl", this.getPersonalSiteWebUrl());
        writer.writeByteArrayValue("photo", this.getPhoto());
        writer.writeStringValue("twitterProfileWebUrl", this.getTwitterProfileWebUrl());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBio(@Nullable ItemBody value) {
        this.backingStore.set("bio", (Object)value);
    }

    public void setCompany(@Nullable String value) {
        this.backingStore.set("company", (Object)value);
    }

    public void setJobTitle(@Nullable String value) {
        this.backingStore.set("jobTitle", (Object)value);
    }

    public void setLinkedInProfileWebUrl(@Nullable String value) {
        this.backingStore.set("linkedInProfileWebUrl", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPersonalSiteWebUrl(@Nullable String value) {
        this.backingStore.set("personalSiteWebUrl", (Object)value);
    }

    public void setPhoto(@Nullable byte[] value) {
        this.backingStore.set("photo", (Object)value);
    }

    public void setTwitterProfileWebUrl(@Nullable String value) {
        this.backingStore.set("twitterProfileWebUrl", (Object)value);
    }
}

