/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttachmentBase;
import com.microsoft.graph.models.AttachmentSession;
import com.microsoft.graph.models.ChecklistItem;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.LinkedResource;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.TaskStatus;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TodoTask
extends Entity
implements Parsable {
    @Nonnull
    public static TodoTask createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TodoTask();
    }

    @Nullable
    public List<AttachmentBase> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public List<AttachmentSession> getAttachmentSessions() {
        return (List)this.backingStore.get("attachmentSessions");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public OffsetDateTime getBodyLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("bodyLastModifiedDateTime");
    }

    @Nullable
    public List<String> getCategories() {
        return (List)this.backingStore.get("categories");
    }

    @Nullable
    public List<ChecklistItem> getChecklistItems() {
        return (List)this.backingStore.get("checklistItems");
    }

    @Nullable
    public DateTimeTimeZone getCompletedDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public DateTimeTimeZone getDueDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("dueDateTime");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(AttachmentBase::createFromDiscriminatorValue)));
        deserializerMap.put("attachmentSessions", n -> this.setAttachmentSessions(n.getCollectionOfObjectValues(AttachmentSession::createFromDiscriminatorValue)));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("bodyLastModifiedDateTime", n -> this.setBodyLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("categories", n -> this.setCategories(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("checklistItems", n -> this.setChecklistItems(n.getCollectionOfObjectValues(ChecklistItem::createFromDiscriminatorValue)));
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("dueDateTime", n -> this.setDueDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("hasAttachments", n -> this.setHasAttachments(n.getBooleanValue()));
        deserializerMap.put("importance", n -> this.setImportance((Importance)n.getEnumValue(Importance::forValue)));
        deserializerMap.put("isReminderOn", n -> this.setIsReminderOn(n.getBooleanValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("linkedResources", n -> this.setLinkedResources(n.getCollectionOfObjectValues(LinkedResource::createFromDiscriminatorValue)));
        deserializerMap.put("recurrence", n -> this.setRecurrence((PatternedRecurrence)n.getObjectValue(PatternedRecurrence::createFromDiscriminatorValue)));
        deserializerMap.put("reminderDateTime", n -> this.setReminderDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((TaskStatus)n.getEnumValue(TaskStatus::forValue)));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getHasAttachments() {
        return (Boolean)this.backingStore.get("hasAttachments");
    }

    @Nullable
    public Importance getImportance() {
        return (Importance)((Object)this.backingStore.get("importance"));
    }

    @Nullable
    public Boolean getIsReminderOn() {
        return (Boolean)this.backingStore.get("isReminderOn");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<LinkedResource> getLinkedResources() {
        return (List)this.backingStore.get("linkedResources");
    }

    @Nullable
    public PatternedRecurrence getRecurrence() {
        return (PatternedRecurrence)this.backingStore.get("recurrence");
    }

    @Nullable
    public DateTimeTimeZone getReminderDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("reminderDateTime");
    }

    @Nullable
    public DateTimeTimeZone getStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("startDateTime");
    }

    @Nullable
    public TaskStatus getStatus() {
        return (TaskStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeCollectionOfObjectValues("attachmentSessions", this.getAttachmentSessions());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("bodyLastModifiedDateTime", this.getBodyLastModifiedDateTime());
        writer.writeCollectionOfPrimitiveValues("categories", this.getCategories());
        writer.writeCollectionOfObjectValues("checklistItems", this.getChecklistItems());
        writer.writeObjectValue("completedDateTime", (Parsable)this.getCompletedDateTime(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("dueDateTime", (Parsable)this.getDueDateTime(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeBooleanValue("hasAttachments", this.getHasAttachments());
        writer.writeEnumValue("importance", (Enum)this.getImportance());
        writer.writeBooleanValue("isReminderOn", this.getIsReminderOn());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("linkedResources", this.getLinkedResources());
        writer.writeObjectValue("recurrence", (Parsable)this.getRecurrence(), new Parsable[0]);
        writer.writeObjectValue("reminderDateTime", (Parsable)this.getReminderDateTime(), new Parsable[0]);
        writer.writeObjectValue("startDateTime", (Parsable)this.getStartDateTime(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("title", this.getTitle());
    }

    public void setAttachments(@Nullable List<AttachmentBase> value) {
        this.backingStore.set("attachments", value);
    }

    public void setAttachmentSessions(@Nullable List<AttachmentSession> value) {
        this.backingStore.set("attachmentSessions", value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setBodyLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("bodyLastModifiedDateTime", (Object)value);
    }

    public void setCategories(@Nullable List<String> value) {
        this.backingStore.set("categories", value);
    }

    public void setChecklistItems(@Nullable List<ChecklistItem> value) {
        this.backingStore.set("checklistItems", value);
    }

    public void setCompletedDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDueDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("dueDateTime", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setHasAttachments(@Nullable Boolean value) {
        this.backingStore.set("hasAttachments", (Object)value);
    }

    public void setImportance(@Nullable Importance value) {
        this.backingStore.set("importance", (Object)value);
    }

    public void setIsReminderOn(@Nullable Boolean value) {
        this.backingStore.set("isReminderOn", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setLinkedResources(@Nullable List<LinkedResource> value) {
        this.backingStore.set("linkedResources", value);
    }

    public void setRecurrence(@Nullable PatternedRecurrence value) {
        this.backingStore.set("recurrence", (Object)value);
    }

    public void setReminderDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("reminderDateTime", (Object)value);
    }

    public void setStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setStatus(@Nullable TaskStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }
}

