/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Shared
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Shared() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Shared createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Shared();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("owner", n -> this.setOwner((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("scope", n -> this.setScope(n.getStringValue()));
        deserializerMap.put("sharedBy", n -> this.setSharedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("sharedDateTime", n -> this.setSharedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public IdentitySet getOwner() {
        return (IdentitySet)this.backingStore.get("owner");
    }

    @Nullable
    public String getScope() {
        return (String)this.backingStore.get("scope");
    }

    @Nullable
    public IdentitySet getSharedBy() {
        return (IdentitySet)this.backingStore.get("sharedBy");
    }

    @Nullable
    public OffsetDateTime getSharedDateTime() {
        return (OffsetDateTime)this.backingStore.get("sharedDateTime");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("owner", (Parsable)this.getOwner(), new Parsable[0]);
        writer.writeStringValue("scope", this.getScope());
        writer.writeObjectValue("sharedBy", (Parsable)this.getSharedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("sharedDateTime", this.getSharedDateTime());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOwner(@Nullable IdentitySet value) {
        this.backingStore.set("owner", (Object)value);
    }

    public void setScope(@Nullable String value) {
        this.backingStore.set("scope", (Object)value);
    }

    public void setSharedBy(@Nullable IdentitySet value) {
        this.backingStore.set("sharedBy", (Object)value);
    }

    public void setSharedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("sharedDateTime", (Object)value);
    }
}

