/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentSchedule;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilitySchedule;
import com.microsoft.graph.models.RequestSchedule;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrivilegedAccessSchedule
extends Entity
implements Parsable {
    @Nonnull
    public static PrivilegedAccessSchedule createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.privilegedAccessGroupAssignmentSchedule": {
                    return new PrivilegedAccessGroupAssignmentSchedule();
                }
                case "#microsoft.graph.privilegedAccessGroupEligibilitySchedule": {
                    return new PrivilegedAccessGroupEligibilitySchedule();
                }
            }
        }
        return new PrivilegedAccessSchedule();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getCreatedUsing() {
        return (String)this.backingStore.get("createdUsing");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("createdUsing", n -> this.setCreatedUsing(n.getStringValue()));
        deserializerMap.put("modifiedDateTime", n -> this.setModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("scheduleInfo", n -> this.setScheduleInfo((RequestSchedule)n.getObjectValue(RequestSchedule::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("modifiedDateTime");
    }

    @Nullable
    public RequestSchedule getScheduleInfo() {
        return (RequestSchedule)this.backingStore.get("scheduleInfo");
    }

    @Nullable
    public String getStatus() {
        return (String)this.backingStore.get("status");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("createdUsing", this.getCreatedUsing());
        writer.writeOffsetDateTimeValue("modifiedDateTime", this.getModifiedDateTime());
        writer.writeObjectValue("scheduleInfo", (Parsable)this.getScheduleInfo(), new Parsable[0]);
        writer.writeStringValue("status", this.getStatus());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCreatedUsing(@Nullable String value) {
        this.backingStore.set("createdUsing", (Object)value);
    }

    public void setModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("modifiedDateTime", (Object)value);
    }

    public void setScheduleInfo(@Nullable RequestSchedule value) {
        this.backingStore.set("scheduleInfo", (Object)value);
    }

    public void setStatus(@Nullable String value) {
        this.backingStore.set("status", (Object)value);
    }
}

