/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceExchangeAccessStateSummary
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceExchangeAccessStateSummary() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceExchangeAccessStateSummary createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceExchangeAccessStateSummary();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Integer getAllowedDeviceCount() {
        return (Integer)this.backingStore.get("allowedDeviceCount");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getBlockedDeviceCount() {
        return (Integer)this.backingStore.get("blockedDeviceCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("allowedDeviceCount", n -> this.setAllowedDeviceCount(n.getIntegerValue()));
        deserializerMap.put("blockedDeviceCount", n -> this.setBlockedDeviceCount(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("quarantinedDeviceCount", n -> this.setQuarantinedDeviceCount(n.getIntegerValue()));
        deserializerMap.put("unavailableDeviceCount", n -> this.setUnavailableDeviceCount(n.getIntegerValue()));
        deserializerMap.put("unknownDeviceCount", n -> this.setUnknownDeviceCount(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getQuarantinedDeviceCount() {
        return (Integer)this.backingStore.get("quarantinedDeviceCount");
    }

    @Nullable
    public Integer getUnavailableDeviceCount() {
        return (Integer)this.backingStore.get("unavailableDeviceCount");
    }

    @Nullable
    public Integer getUnknownDeviceCount() {
        return (Integer)this.backingStore.get("unknownDeviceCount");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("allowedDeviceCount", this.getAllowedDeviceCount());
        writer.writeIntegerValue("blockedDeviceCount", this.getBlockedDeviceCount());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("quarantinedDeviceCount", this.getQuarantinedDeviceCount());
        writer.writeIntegerValue("unavailableDeviceCount", this.getUnavailableDeviceCount());
        writer.writeIntegerValue("unknownDeviceCount", this.getUnknownDeviceCount());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowedDeviceCount(@Nullable Integer value) {
        this.backingStore.set("allowedDeviceCount", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBlockedDeviceCount(@Nullable Integer value) {
        this.backingStore.set("blockedDeviceCount", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setQuarantinedDeviceCount(@Nullable Integer value) {
        this.backingStore.set("quarantinedDeviceCount", (Object)value);
    }

    public void setUnavailableDeviceCount(@Nullable Integer value) {
        this.backingStore.set("unavailableDeviceCount", (Object)value);
    }

    public void setUnknownDeviceCount(@Nullable Integer value) {
        this.backingStore.set("unknownDeviceCount", (Object)value);
    }
}

