/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.applications.item.addkey;

import com.microsoft.graph.models.KeyCredential;
import com.microsoft.graph.models.PasswordCredential;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AddKeyPostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AddKeyPostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AddKeyPostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AddKeyPostRequestBody();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(3);
        deserializerMap.put("keyCredential", n -> this.setKeyCredential((KeyCredential)n.getObjectValue(KeyCredential::createFromDiscriminatorValue)));
        deserializerMap.put("passwordCredential", n -> this.setPasswordCredential((PasswordCredential)n.getObjectValue(PasswordCredential::createFromDiscriminatorValue)));
        deserializerMap.put("proof", n -> this.setProof(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public KeyCredential getKeyCredential() {
        return (KeyCredential)this.backingStore.get("keyCredential");
    }

    @Nullable
    public PasswordCredential getPasswordCredential() {
        return (PasswordCredential)this.backingStore.get("passwordCredential");
    }

    @Nullable
    public String getProof() {
        return (String)this.backingStore.get("proof");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("keyCredential", (Parsable)this.getKeyCredential(), new Parsable[0]);
        writer.writeObjectValue("passwordCredential", (Parsable)this.getPasswordCredential(), new Parsable[0]);
        writer.writeStringValue("proof", this.getProof());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setKeyCredential(@Nullable KeyCredential value) {
        this.backingStore.set("keyCredential", (Object)value);
    }

    public void setPasswordCredential(@Nullable PasswordCredential value) {
        this.backingStore.set("passwordCredential", (Object)value);
    }

    public void setProof(@Nullable String value) {
        this.backingStore.set("proof", (Object)value);
    }
}

