/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseFilterUtil;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.internal.hppc.CharObjectHashMap;

public final class JapaneseKatakanaUppercaseFilter
extends TokenFilter {
    private static final CharObjectHashMap<Character> LETTER_MAPPINGS = JapaneseFilterUtil.createCharMap(Map.entry(Character.valueOf('\u30a1'), Character.valueOf('\u30a2')), Map.entry(Character.valueOf('\u30a3'), Character.valueOf('\u30a4')), Map.entry(Character.valueOf('\u30a5'), Character.valueOf('\u30a6')), Map.entry(Character.valueOf('\u30a7'), Character.valueOf('\u30a8')), Map.entry(Character.valueOf('\u30a9'), Character.valueOf('\u30aa')), Map.entry(Character.valueOf('\u30f5'), Character.valueOf('\u30ab')), Map.entry(Character.valueOf('\u31f0'), Character.valueOf('\u30af')), Map.entry(Character.valueOf('\u30f6'), Character.valueOf('\u30b1')), Map.entry(Character.valueOf('\u31f1'), Character.valueOf('\u30b7')), Map.entry(Character.valueOf('\u31f2'), Character.valueOf('\u30b9')), Map.entry(Character.valueOf('\u30c3'), Character.valueOf('\u30c4')), Map.entry(Character.valueOf('\u31f3'), Character.valueOf('\u30c8')), Map.entry(Character.valueOf('\u31f4'), Character.valueOf('\u30cc')), Map.entry(Character.valueOf('\u31f5'), Character.valueOf('\u30cf')), Map.entry(Character.valueOf('\u31f6'), Character.valueOf('\u30d2')), Map.entry(Character.valueOf('\u31f7'), Character.valueOf('\u30d5')), Map.entry(Character.valueOf('\u31f8'), Character.valueOf('\u30d8')), Map.entry(Character.valueOf('\u31f9'), Character.valueOf('\u30db')), Map.entry(Character.valueOf('\u31fa'), Character.valueOf('\u30e0')), Map.entry(Character.valueOf('\u30e3'), Character.valueOf('\u30e4')), Map.entry(Character.valueOf('\u30e5'), Character.valueOf('\u30e6')), Map.entry(Character.valueOf('\u30e7'), Character.valueOf('\u30e8')), Map.entry(Character.valueOf('\u31fb'), Character.valueOf('\u30e9')), Map.entry(Character.valueOf('\u31fc'), Character.valueOf('\u30ea')), Map.entry(Character.valueOf('\u31fd'), Character.valueOf('\u30eb')), Map.entry(Character.valueOf('\u31fe'), Character.valueOf('\u30ec')), Map.entry(Character.valueOf('\u31ff'), Character.valueOf('\u30ed')), Map.entry(Character.valueOf('\u30ee'), Character.valueOf('\u30ef')));
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public JapaneseKatakanaUppercaseFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAttr.buffer();
        int newLength = this.termAttr.length();
        int from = 0;
        int to = 0;
        int length = newLength;
        while (from < length) {
            char c = termBuffer[from];
            if (c == '\u31f7' && from + 1 < length && termBuffer[from + 1] == '\u309a') {
                termBuffer[to] = 12503;
                ++from;
                --newLength;
            } else {
                Character mappedChar = (Character)LETTER_MAPPINGS.get(c);
                termBuffer[to] = mappedChar == null ? c : mappedChar.charValue();
            }
            ++from;
            ++to;
        }
        this.termAttr.setLength(newLength);
        return true;
    }
}

