/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.security.SecureSettings;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.ConnectTimeoutException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.params.HttpConnectionParams;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

class SSLSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(SSLSocketFactory.class);
    private SSLContext sslContext = null;
    private final String sslProtocol;
    private final String keyStoreLocation;
    private final String keyStorePass;
    private final String keyStoreType;
    private final String trustStoreLocation;
    private final String trustStorePass;
    private final TrustStrategy trust;

    SSLSocketFactory(Settings settings, SecureSettings secureSettings) {
        this.sslProtocol = settings.getNetworkSSLProtocol();
        this.keyStoreLocation = settings.getNetworkSSLKeyStoreLocation();
        this.keyStorePass = secureSettings.getSecureProperty("es.net.ssl.keystore.pass");
        this.keyStoreType = settings.getNetworkSSLKeyStoreType();
        this.trustStoreLocation = settings.getNetworkSSLTrustStoreLocation();
        this.trustStorePass = secureSettings.getSecureProperty("es.net.ssl.truststore.pass");
        this.trust = settings.getNetworkSSLAcceptSelfSignedCert() ? new SelfSignedStrategy() : null;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params2) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params2.getConnectionTimeout();
        javax.net.ssl.SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, localAddress, localPort);
    }

    private SSLContext getSSLContext() {
        if (this.sslContext == null) {
            this.sslContext = this.createSSLContext();
        }
        return this.sslContext;
    }

    private SSLContext createSSLContext() {
        SSLContext ctx;
        try {
            ctx = SSLContext.getInstance(this.sslProtocol);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EsHadoopIllegalStateException("Cannot instantiate SSL - " + ex.getMessage(), ex);
        }
        try {
            ctx.init(this.loadKeyManagers(), this.loadTrustManagers(), null);
        }
        catch (Exception ex) {
            throw new EsHadoopIllegalStateException("Cannot initialize SSL - " + ex.getMessage(), ex);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String location, char[] pass) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        InputStream in = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading keystore located at [" + location + "]"));
            }
            try {
                in = IOUtils.open(location);
                if (in == null) {
                    throw new EsHadoopIllegalArgumentException(String.format("Could not locate [%s] on classpath", location));
                }
            }
            catch (Exception e) {
                throw new EsHadoopIllegalArgumentException(String.format("Expected to find keystore file at [%s] but was unable to. Make sure that it is available on the classpath, or if not, that you have specified a valid URI.", location));
            }
            keyStore.load(in, pass);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return keyStore;
    }

    private KeyManager[] loadKeyManagers() throws GeneralSecurityException, IOException {
        if (!StringUtils.hasText(this.keyStoreLocation)) {
            LOG.debug((Object)"No keystore location specified! SSL is continuing with no keystore.");
            return null;
        }
        char[] pass = StringUtils.hasText(this.keyStorePass) ? this.keyStorePass.trim().toCharArray() : null;
        KeyStore keyStore = this.loadKeyStore(this.keyStoreLocation, pass);
        KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmFactory.init(keyStore, pass);
        return kmFactory.getKeyManagers();
    }

    private TrustManager[] loadTrustManagers() throws GeneralSecurityException, IOException {
        KeyStore keyStore = null;
        if (StringUtils.hasText(this.trustStoreLocation)) {
            char[] pass = StringUtils.hasText(this.trustStorePass) ? this.trustStorePass.trim().toCharArray() : null;
            keyStore = this.loadKeyStore(this.trustStoreLocation, pass);
        } else {
            LOG.debug((Object)"No truststore location specified! SSL is continuing with no truststore.");
        }
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(keyStore);
        TrustManager[] tms = tmFactory.getTrustManagers();
        if (tms != null && this.trust != null) {
            TrustManager[] clone = new TrustManager[tms.length];
            for (int i = 0; i < tms.length; ++i) {
                TrustManager tm = tms[i];
                if (tm instanceof X509TrustManager) {
                    tm = new TrustManagerDelegate((X509TrustManager)tm, this.trust);
                }
                clone[i] = tm;
            }
            tms = clone;
        }
        return tms;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(SSLSocketFactory.class);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static class SelfSignedStrategy
    implements TrustStrategy {
        private SelfSignedStrategy() {
        }

        @Override
        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return chain.length == 1;
        }
    }

    private static interface TrustStrategy {
        public boolean isTrusted(X509Certificate[] var1, String var2) throws CertificateException;
    }

    private static class TrustManagerDelegate
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private final TrustStrategy trustStrategy;

        TrustManagerDelegate(X509TrustManager trustManager, TrustStrategy trustStrategy) {
            this.trustManager = trustManager;
            this.trustStrategy = trustStrategy;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.trustStrategy.isTrusted(chain, authType)) {
                this.trustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

