/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.AbstractDefaultParamsExtractor;
import org.elasticsearch.hadoop.serialization.field.AbstractIndexExtractor;
import org.elasticsearch.hadoop.serialization.field.ChainedFieldExtractor;
import org.elasticsearch.hadoop.serialization.field.ExtractorUtils;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class JsonFieldExtractors {
    private static Log log = LogFactory.getLog(JsonFieldExtractors.class);
    private final Settings settings;
    private final List<Object> results = new ArrayList<Object>(6);
    private String[] paths;
    private FieldExtractor id;
    private FieldExtractor parent;
    private FieldExtractor routing;
    private FieldExtractor ttl;
    private FieldExtractor version;
    private FieldExtractor timestamp;
    private AbstractIndexExtractor indexExtractor;
    private AbstractDefaultParamsExtractor params;

    public JsonFieldExtractors(Settings settings) {
        this.settings = settings;
        final ArrayList<String> jsonPaths = new ArrayList<String>();
        this.id = this.init(settings.getMappingId(), jsonPaths);
        this.parent = this.init(settings.getMappingParent(), jsonPaths);
        ArrayList<FieldExtractor> routings = new ArrayList<FieldExtractor>(2);
        this.initAndAdd(settings.getMappingRouting(), jsonPaths, routings);
        this.initAndAdd(MappingUtils.joinParentField(settings), jsonPaths, routings);
        this.routing = routings.size() != 0 ? new ChainedFieldExtractor(routings) : null;
        this.ttl = this.init(settings.getMappingTtl(), jsonPaths);
        this.version = this.init(settings.getMappingVersion(), jsonPaths);
        this.timestamp = this.init(settings.getMappingTimestamp(), jsonPaths);
        this.indexExtractor = new AbstractIndexExtractor(){

            @Override
            protected FieldExtractor createFieldExtractor(String fieldName) {
                return JsonFieldExtractors.this.createJsonFieldExtractor(fieldName, jsonPaths, false);
            }
        };
        this.indexExtractor.setSettings(settings);
        this.indexExtractor.compile(new Resource(settings, false).toString());
        AbstractIndexExtractor abstractIndexExtractor = this.indexExtractor = this.indexExtractor.hasPattern() ? this.indexExtractor : null;
        if (settings.hasUpdateScriptParams()) {
            this.params = new AbstractDefaultParamsExtractor(){

                @Override
                protected FieldExtractor createFieldExtractor(String fieldName) {
                    return JsonFieldExtractors.this.init(fieldName, jsonPaths);
                }
            };
            this.params.setSettings(settings);
        }
        this.paths = jsonPaths.toArray(new String[jsonPaths.size()]);
    }

    private void initAndAdd(String fieldName, List<String> pathList, List<FieldExtractor> results) {
        FieldExtractor result = this.init(fieldName, pathList);
        if (result != null) {
            results.add(result);
        }
    }

    private FieldExtractor init(String fieldName, List<String> pathList) {
        if (fieldName != null) {
            Object constant = this.initConstant(fieldName);
            if (constant != null) {
                return new FixedFieldExtractor(constant);
            }
            return this.createJsonFieldExtractor(fieldName, pathList, true);
        }
        return null;
    }

    private FieldExtractor createJsonFieldExtractor(String fieldName, List<String> pathList, boolean asJson) {
        pathList.add(fieldName);
        return new PrecomputedFieldExtractor(pathList.size() - 1, fieldName, asJson);
    }

    private Object initConstant(String field) {
        if (field != null && field.startsWith("<") && field.endsWith(">")) {
            return ExtractorUtils.extractConstant(field.substring(1, field.length() - 1), this.settings.getMappingConstantAutoQuote());
        }
        return null;
    }

    public IndexExtractor indexAndType() {
        return this.indexExtractor;
    }

    public FieldExtractor id() {
        return this.id;
    }

    public FieldExtractor parent() {
        return this.parent;
    }

    public FieldExtractor routing() {
        return this.routing;
    }

    public FieldExtractor ttl() {
        return this.ttl;
    }

    public FieldExtractor version() {
        return this.version;
    }

    public FieldExtractor timestamp() {
        return this.timestamp;
    }

    public void process(BytesArray storage) {
        if (ObjectUtils.isEmpty(this.paths)) {
            return;
        }
        this.results.clear();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("About to look for paths [%s] in doc [%s]", Arrays.toString(this.paths), storage));
        }
        this.results.addAll(ParsingUtils.values(new JacksonJsonParser(storage.bytes(), 0, storage.length()), this.paths));
    }

    public FieldExtractor params() {
        return this.params;
    }

    private static class FixedFieldExtractor
    implements FieldExtractor {
        private final Object value;

        public FixedFieldExtractor(Object value) {
            this.value = value;
        }

        @Override
        public Object field(Object target) {
            return this.value;
        }

        public String toString() {
            return "ConstantJsonExtractor";
        }
    }

    class PrecomputedFieldExtractor
    implements FieldExtractor {
        private final int slot;
        private final String fieldName;
        private final boolean returnAsJson;

        public PrecomputedFieldExtractor(int slot, String fieldName, boolean returnAsJson) {
            this.slot = slot;
            this.fieldName = fieldName;
            this.returnAsJson = returnAsJson;
        }

        @Override
        public Object field(Object target) {
            Object result = JsonFieldExtractors.this.results.get(this.slot);
            if (result == "(not found)") {
                return FieldExtractor.NOT_FOUND;
            }
            return this.returnAsJson ? StringUtils.toJsonString(result) : result;
        }

        public String toString() {
            return String.format("JsonExtractor for field [%s]", this.fieldName);
        }
    }
}

