/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.Source;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.DocumentUriFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AnyURIValue;

public class UriCollection
extends SystemFunctionCall
implements Callable {
    private String expressionBaseURI = null;

    public void bindStaticContext(StaticContext env) throws XPathException {
        this.expressionBaseURI = env.getBaseURI();
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator iter;
        Item item;
        String href = this.getNumberOfArguments() == 0 ? context.getConfiguration().getDefaultCollection() : ((item = this.argument[0].evaluateItem(context)) == null ? context.getConfiguration().getDefaultCollection() : item.getStringValue());
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return UriCollection.getResolverResults(iter, context);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator iter;
        Item arg;
        String href = arguments.length == 0 ? context.getConfiguration().getDefaultCollection() : ((arg = arguments[0].head()) == null ? context.getConfiguration().getDefaultCollection() : arg.getStringValue());
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return SequenceTool.toLazySequence(UriCollection.getResolverResults(iter, context));
    }

    private static SequenceIterator getResolverResults(SequenceIterator iter, final XPathContext context) {
        if (iter == null) {
            return EmptyIterator.emptyIterator();
        }
        ItemMappingFunction<Item, AnyURIValue> imf = new ItemMappingFunction<Item, AnyURIValue>(){

            @Override
            public AnyURIValue mapItem(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return DocumentUriFn.getDocumentURI((NodeInfo)item, context);
                }
                if (item instanceof Source) {
                    return new AnyURIValue(((Source)((Object)item)).getSystemId());
                }
                if (item instanceof AnyURIValue) {
                    return (AnyURIValue)item;
                }
                throw new XPathException("Value returned by CollectionURIResolver must be a Source or an anyURI");
            }
        };
        return new ItemMappingIterator<Item, AnyURIValue>(iter, imf);
    }
}

