/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import co.elastic.logstash.api.DeprecationLogger;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.log.DefaultDeprecationLogger;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineBusV1;
import org.logstash.plugins.pipeline.PipelineBusV2;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;

public interface PipelineBus {
    public static final Logger LOGGER = LogManager.getLogger(PipelineBus.class);
    public static final DeprecationLogger DEPRECATION_LOGGER = new DefaultDeprecationLogger(LOGGER);

    public static PipelineBus create() {
        String pipelineBusImplementation = System.getProperty("logstash.pipelinebus.implementation");
        if (Objects.isNull(pipelineBusImplementation)) {
            return new PipelineBusV2();
        }
        String deprecationLogBase = "The pipeline bus selector `logstash.pipelinebus.implementation` system property is deprecated and will be ignored in Logstash 9.0";
        switch (pipelineBusImplementation) {
            case "v1": {
                LOGGER.debug("pipeline bus `v1` has been selected");
                DEPRECATION_LOGGER.deprecated("The pipeline bus selector `logstash.pipelinebus.implementation` system property is deprecated and will be ignored in Logstash 9.0; the selected `v1` will also be removed.", new Object[0]);
                return new PipelineBusV1();
            }
            case "v2": {
                LOGGER.debug("pipeline bus `v2` has been selected");
                DEPRECATION_LOGGER.deprecated("The pipeline bus selector `logstash.pipelinebus.implementation` system property is deprecated and will be ignored in Logstash 9.0; the selected `v2` is redundant because the default value is `v2`", new Object[0]);
                return new PipelineBusV2();
            }
        }
        DEPRECATION_LOGGER.deprecated("The pipeline bus selector `logstash.pipelinebus.implementation` system property is deprecated and will be ignored in Logstash 9.0", new Object[0]);
        LOGGER.warn("unknown pipeline-bus implementation: {} default `v2` will be used.", (Object)pipelineBusImplementation);
        return new PipelineBusV2();
    }

    public void sendEvents(PipelineOutput var1, Collection<JrubyEventExtLibrary.RubyEvent> var2, boolean var3);

    public void registerSender(PipelineOutput var1, Iterable<String> var2);

    public void unregisterSender(PipelineOutput var1, Iterable<String> var2);

    public boolean listen(PipelineInput var1, String var2);

    public void unlisten(PipelineInput var1, String var2) throws InterruptedException;

    public void setBlockOnUnlisten(boolean var1);

    @VisibleForTesting
    public static interface Testable
    extends PipelineBus {
        @VisibleForTesting
        public Optional<AddressState.ReadOnly> getAddressState(String var1);

        @VisibleForTesting
        public Optional<Set<AddressState.ReadOnly>> getAddressStates(PipelineOutput var1);

        @VisibleForTesting
        public boolean isBlockOnUnlisten();
    }
}

