/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import org.logstash.config.ir.compiler.SyntaxElement;
import org.logstash.config.ir.compiler.SyntaxFactory;
import org.logstash.config.ir.compiler.VariableDefinition;

final class FieldDefinition
implements SyntaxElement {
    private final VariableDefinition def;
    private final boolean mutable;
    private final SyntaxElement initializer;
    private final Object ctorArgument;

    public static FieldDefinition fromValue(int index, Object value) {
        return new FieldDefinition(FieldDefinition.variableDefinition(value.getClass(), index), false, null, value);
    }

    public static FieldDefinition fromValue(String fieldName, Object value) {
        return new FieldDefinition(FieldDefinition.variableDefinition(value.getClass(), fieldName), false, null, value);
    }

    public static FieldDefinition mutableUnassigned(int index, Class<?> type) {
        return new FieldDefinition(FieldDefinition.variableDefinition(type, index), true, null, null);
    }

    public static FieldDefinition mutableUnassigned(String fieldName, Class<?> type) {
        return new FieldDefinition(FieldDefinition.variableDefinition(type, fieldName), true, null, null);
    }

    private FieldDefinition(VariableDefinition typeDef, boolean mutable, SyntaxElement initializer, Object ctorArgument) {
        this.def = typeDef;
        this.mutable = mutable;
        this.initializer = initializer;
        this.ctorArgument = ctorArgument;
    }

    public VariableDefinition asVariable() {
        return this.def;
    }

    public Object getCtorArgument() {
        return this.ctorArgument;
    }

    public String getName() {
        return this.def.name;
    }

    @Override
    public String generateCode() {
        return SyntaxFactory.join("private ", this.mutable ? "" : "final ", this.def.generateCode(), this.initializer != null ? SyntaxFactory.join("=", this.initializer.generateCode()) : "");
    }

    private static VariableDefinition variableDefinition(Class<?> type, int index) {
        return new VariableDefinition(type, String.format("field%d", index));
    }

    private static VariableDefinition variableDefinition(Class<?> type, String fieldName) {
        return new VariableDefinition(type, String.format("%sField", fieldName));
    }
}

