/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.saml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.authc.support.SecuritySettingsUtil;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.X509KeyPairSettings;

public class SamlRealmSettings {
    public static final String TYPE = "saml";
    private static final String IDP_METADATA_SETTING_PREFIX = "idp.metadata.";
    public static final Setting.AffixSetting<String> IDP_ENTITY_ID = RealmSettings.simpleString("saml", "idp.entity_id", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> IDP_METADATA_PATH = RealmSettings.simpleString("saml", "idp.metadata.path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<TimeValue> IDP_METADATA_HTTP_REFRESH = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "idp.metadata.http.refresh", key -> Setting.timeSetting(key, TimeValue.timeValueHours(1L), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> IDP_METADATA_HTTP_MIN_REFRESH = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "idp.metadata.http.minimum_refresh", key -> Setting.timeSetting(key, TimeValue.timeValueMinutes(5L), TimeValue.timeValueMillis(500L), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> IDP_METADATA_HTTP_FAIL_ON_ERROR = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "idp.metadata.http.fail_on_error", key -> Setting.boolSetting(key, false, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> IDP_SINGLE_LOGOUT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "idp.use_single_logout", key -> Setting.boolSetting(key, true, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> SP_ENTITY_ID = RealmSettings.simpleString("saml", "sp.entity_id", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> SP_ACS = RealmSettings.simpleString("saml", "sp.acs", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> SP_LOGOUT = RealmSettings.simpleString("saml", "sp.logout", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NAMEID_FORMAT = RealmSettings.simpleString("saml", "nameid_format", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Boolean> NAMEID_ALLOW_CREATE = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "nameid.allow_create", key -> Setting.boolSetting(key, false, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> NAMEID_SP_QUALIFIER = RealmSettings.simpleString("saml", "nameid.sp_qualifier", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Boolean> FORCE_AUTHN = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "force_authn", key -> Setting.boolSetting(key, false, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> POPULATE_USER_METADATA = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "populate_user_metadata", key -> Setting.boolSetting(key, true, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final AttributeSetting PRINCIPAL_ATTRIBUTE = new AttributeSetting("principal");
    public static final AttributeSettingWithDelimiter GROUPS_ATTRIBUTE = new AttributeSettingWithDelimiter("groups");
    public static final AttributeSetting DN_ATTRIBUTE = new AttributeSetting("dn");
    public static final AttributeSetting NAME_ATTRIBUTE = new AttributeSetting("name");
    public static final AttributeSetting MAIL_ATTRIBUTE = new AttributeSetting("mail");
    public static final String ENCRYPTION_SETTING_KEY = "encryption.";
    public static final Setting.AffixSetting<String> ENCRYPTION_KEY_ALIAS = RealmSettings.simpleString("saml", "encryption.keystore.alias", Setting.Property.NodeScope);
    public static final String SIGNING_SETTING_KEY = "signing.";
    public static final Setting.AffixSetting<String> SIGNING_KEY_ALIAS = RealmSettings.simpleString("saml", "signing.keystore.alias", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<List<String>> SIGNING_MESSAGE_TYPES = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "signing.saml_messages", key -> Setting.stringListSetting(key, List.of("*"), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> REQUESTED_AUTHN_CONTEXT_CLASS_REF = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "req_authn_context_class_ref", key -> Setting.stringListSetting(key, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> CLOCK_SKEW = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "allowed_clock_skew", key -> Setting.positiveTimeSetting(key, TimeValue.timeValueMinutes(3L), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> EXCLUDE_ROLES = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("saml"), "exclude_roles", key -> Setting.stringListSetting(key, new Setting.Validator<List<String>>(){

        @Override
        public void validate(List<String> excludedRoles) {
            excludedRoles.forEach(excludedRole -> SecuritySettingsUtil.verifyNonNullNotEmpty(key, excludedRole));
        }

        @Override
        public void validate(List<String> excludedRoles, Map<Setting<?>, Object> settings) {
            if (!excludedRoles.isEmpty()) {
                String namespace = EXCLUDE_ROLES.getNamespace(EXCLUDE_ROLES.getConcreteSetting(key));
                Setting<List<String>> authorizationRealmsSetting = DelegatedAuthorizationSettings.AUTHZ_REALMS.apply(SamlRealmSettings.TYPE).getConcreteSettingForNamespace(namespace);
                List authorizationRealms = (List)settings.get(authorizationRealmsSetting);
                if (authorizationRealms != null && !authorizationRealms.isEmpty()) {
                    throw new SettingsException("Setting [" + EXCLUDE_ROLES.getConcreteSettingForNamespace(namespace).getKey() + "] is not permitted when setting [" + authorizationRealmsSetting.getKey() + "] is configured.");
                }
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            String namespace = EXCLUDE_ROLES.getNamespace(EXCLUDE_ROLES.getConcreteSetting(key));
            List<Setting<List<String>>> settings = List.of(DelegatedAuthorizationSettings.AUTHZ_REALMS.apply(SamlRealmSettings.TYPE).getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final String SSL_PREFIX = "ssl.";

    private SamlRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet<Setting.AffixSetting<?>> set = Sets.newHashSet(IDP_ENTITY_ID, IDP_METADATA_PATH, IDP_METADATA_HTTP_REFRESH, IDP_METADATA_HTTP_MIN_REFRESH, IDP_METADATA_HTTP_FAIL_ON_ERROR, IDP_SINGLE_LOGOUT, SP_ENTITY_ID, SP_ACS, SP_LOGOUT, NAMEID_FORMAT, NAMEID_ALLOW_CREATE, NAMEID_SP_QUALIFIER, FORCE_AUTHN, POPULATE_USER_METADATA, CLOCK_SKEW, ENCRYPTION_KEY_ALIAS, SIGNING_KEY_ALIAS, SIGNING_MESSAGE_TYPES, REQUESTED_AUTHN_CONTEXT_CLASS_REF);
        set.addAll(X509KeyPairSettings.affix(RealmSettings.realmSettingPrefix(TYPE), ENCRYPTION_SETTING_KEY, false));
        set.addAll(X509KeyPairSettings.affix(RealmSettings.realmSettingPrefix(TYPE), SIGNING_SETTING_KEY, false));
        set.addAll(SSLConfigurationSettings.getRealmSettings(TYPE));
        set.addAll(PRINCIPAL_ATTRIBUTE.settings());
        set.addAll(GROUPS_ATTRIBUTE.settings());
        set.addAll(DN_ATTRIBUTE.settings());
        set.addAll(NAME_ATTRIBUTE.settings());
        set.addAll(MAIL_ATTRIBUTE.settings());
        set.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        set.addAll(RealmSettings.getStandardSettings(TYPE));
        return set;
    }

    public static final class AttributeSetting {
        public static final String ATTRIBUTES_PREFIX = "attributes.";
        public static final String ATTRIBUTE_PATTERNS_PREFIX = "attribute_patterns.";
        private final Setting.AffixSetting<String> attribute;
        private final Setting.AffixSetting<String> pattern;

        public AttributeSetting(String name) {
            this.attribute = RealmSettings.simpleString(SamlRealmSettings.TYPE, ATTRIBUTES_PREFIX + name, Setting.Property.NodeScope);
            this.pattern = RealmSettings.simpleString(SamlRealmSettings.TYPE, ATTRIBUTE_PATTERNS_PREFIX + name, Setting.Property.NodeScope);
        }

        public Collection<Setting.AffixSetting<?>> settings() {
            return Arrays.asList(this.getAttribute(), this.getPattern());
        }

        public String name(RealmConfig config) {
            return this.getAttribute().getConcreteSettingForNamespace(config.name()).getKey();
        }

        public Setting.AffixSetting<String> getAttribute() {
            return this.attribute;
        }

        public Setting.AffixSetting<String> getPattern() {
            return this.pattern;
        }
    }

    public static final class AttributeSettingWithDelimiter {
        public static final String ATTRIBUTE_DELIMITERS_PREFIX = "attribute_delimiters.";
        private final Setting.AffixSetting<String> delimiter;
        private final AttributeSetting attributeSetting;

        public AttributeSetting getAttributeSetting() {
            return this.attributeSetting;
        }

        public AttributeSettingWithDelimiter(String name) {
            this.attributeSetting = new AttributeSetting(name);
            this.delimiter = RealmSettings.simpleString(SamlRealmSettings.TYPE, ATTRIBUTE_DELIMITERS_PREFIX + name, Setting.Property.NodeScope);
        }

        public Setting.AffixSetting<String> getDelimiter() {
            return this.delimiter;
        }

        public Collection<Setting.AffixSetting<?>> settings() {
            ArrayList settings = new ArrayList(this.attributeSetting.settings());
            settings.add(this.getDelimiter());
            return settings;
        }
    }
}

