/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.search.spell.LuceneLevenshteinDistance;
import org.apache.lucene.search.spell.NGramDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestMode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.search.suggest.SortBy;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class DirectCandidateGeneratorBuilder
implements PhraseSuggestionBuilder.CandidateGenerator {
    private static final String TYPE = "direct_generator";
    public static final ParseField DIRECT_GENERATOR_FIELD = new ParseField("direct_generator", new String[0]);
    public static final ParseField FIELDNAME_FIELD = new ParseField("field", new String[0]);
    public static final ParseField PREFILTER_FIELD = new ParseField("pre_filter", new String[0]);
    public static final ParseField POSTFILTER_FIELD = new ParseField("post_filter", new String[0]);
    public static final ParseField SUGGESTMODE_FIELD = new ParseField("suggest_mode", new String[0]);
    public static final ParseField MIN_DOC_FREQ_FIELD = new ParseField("min_doc_freq", new String[0]);
    public static final ParseField ACCURACY_FIELD = new ParseField("accuracy", new String[0]);
    public static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
    public static final ParseField STRING_DISTANCE_FIELD = new ParseField("string_distance", new String[0]);
    public static final ParseField MAX_EDITS_FIELD = new ParseField("max_edits", new String[0]);
    public static final ParseField MAX_INSPECTIONS_FIELD = new ParseField("max_inspections", new String[0]);
    public static final ParseField MAX_TERM_FREQ_FIELD = new ParseField("max_term_freq", new String[0]);
    public static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    public static final ParseField MIN_WORD_LENGTH_FIELD = new ParseField("min_word_length", new String[0]);
    private final String field;
    private String preFilter;
    private String postFilter;
    private String suggestMode;
    private Float accuracy;
    private Integer size;
    private String sort;
    private String stringDistance;
    private Integer maxEdits;
    private Integer maxInspections;
    private Float maxTermFreq;
    private Integer prefixLength;
    private Integer minWordLength;
    private Float minDocFreq;
    public static final ConstructingObjectParser<DirectCandidateGeneratorBuilder, Void> PARSER = new ConstructingObjectParser("direct_generator", args -> new DirectCandidateGeneratorBuilder((String)args[0]));

    public DirectCandidateGeneratorBuilder(String field) {
        this.field = field;
    }

    public DirectCandidateGeneratorBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.suggestMode = in.readOptionalString();
        this.accuracy = in.readOptionalFloat();
        this.size = in.readOptionalVInt();
        this.sort = in.readOptionalString();
        this.stringDistance = in.readOptionalString();
        this.maxEdits = in.readOptionalVInt();
        this.maxInspections = in.readOptionalVInt();
        this.maxTermFreq = in.readOptionalFloat();
        this.prefixLength = in.readOptionalVInt();
        this.minWordLength = in.readOptionalVInt();
        this.minDocFreq = in.readOptionalFloat();
        this.preFilter = in.readOptionalString();
        this.postFilter = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeOptionalString(this.suggestMode);
        out.writeOptionalFloat(this.accuracy);
        out.writeOptionalVInt(this.size);
        out.writeOptionalString(this.sort);
        out.writeOptionalString(this.stringDistance);
        out.writeOptionalVInt(this.maxEdits);
        out.writeOptionalVInt(this.maxInspections);
        out.writeOptionalFloat(this.maxTermFreq);
        out.writeOptionalVInt(this.prefixLength);
        out.writeOptionalVInt(this.minWordLength);
        out.writeOptionalFloat(this.minDocFreq);
        out.writeOptionalString(this.preFilter);
        out.writeOptionalString(this.postFilter);
    }

    String field() {
        return this.field;
    }

    public DirectCandidateGeneratorBuilder suggestMode(String suggestMode) {
        this.suggestMode = suggestMode;
        return this;
    }

    String suggestMode() {
        return this.suggestMode;
    }

    public DirectCandidateGeneratorBuilder accuracy(float accuracy) {
        this.accuracy = Float.valueOf(accuracy);
        return this;
    }

    Float accuracy() {
        return this.accuracy;
    }

    public DirectCandidateGeneratorBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.size = size;
        return this;
    }

    Integer size() {
        return this.size;
    }

    public DirectCandidateGeneratorBuilder sort(String sort) {
        this.sort = sort;
        return this;
    }

    String sort() {
        return this.sort;
    }

    public DirectCandidateGeneratorBuilder stringDistance(String stringDistance) {
        this.stringDistance = stringDistance;
        return this;
    }

    String stringDistance() {
        return this.stringDistance;
    }

    public DirectCandidateGeneratorBuilder maxEdits(Integer maxEdits) {
        if (maxEdits < 1 || maxEdits > 2) {
            throw new IllegalArgumentException("Illegal max_edits value " + maxEdits);
        }
        this.maxEdits = maxEdits;
        return this;
    }

    Integer maxEdits() {
        return this.maxEdits;
    }

    public DirectCandidateGeneratorBuilder maxInspections(Integer maxInspections) {
        this.maxInspections = maxInspections;
        return this;
    }

    Integer maxInspections() {
        return this.maxInspections;
    }

    public DirectCandidateGeneratorBuilder maxTermFreq(float maxTermFreq) {
        this.maxTermFreq = Float.valueOf(maxTermFreq);
        return this;
    }

    Float maxTermFreq() {
        return this.maxTermFreq;
    }

    public DirectCandidateGeneratorBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    Integer prefixLength() {
        return this.prefixLength;
    }

    public DirectCandidateGeneratorBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    Integer minWordLength() {
        return this.minWordLength;
    }

    public DirectCandidateGeneratorBuilder minDocFreq(float minDocFreq) {
        this.minDocFreq = Float.valueOf(minDocFreq);
        return this;
    }

    Float minDocFreq() {
        return this.minDocFreq;
    }

    public DirectCandidateGeneratorBuilder preFilter(String preFilter) {
        this.preFilter = preFilter;
        return this;
    }

    String preFilter() {
        return this.preFilter;
    }

    public DirectCandidateGeneratorBuilder postFilter(String postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    String postFilter() {
        return this.postFilter;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.field, FIELDNAME_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.accuracy, ACCURACY_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.maxEdits, MAX_EDITS_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.maxInspections, MAX_INSPECTIONS_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.maxTermFreq, MAX_TERM_FREQ_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.minWordLength, MIN_WORD_LENGTH_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.minDocFreq, MIN_DOC_FREQ_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.preFilter, PREFILTER_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.prefixLength, PREFIX_LENGTH_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.postFilter, POSTFILTER_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.suggestMode, SUGGESTMODE_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.size, SIZE_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.sort, SORT_FIELD, builder);
        DirectCandidateGeneratorBuilder.outputFieldIfNotNull(this.stringDistance, STRING_DISTANCE_FIELD, builder);
        builder.endObject();
        return builder;
    }

    private static <T> void outputFieldIfNotNull(T value, ParseField field, XContentBuilder builder) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    @Override
    public PhraseSuggestionContext.DirectCandidateGenerator build(IndexAnalyzers indexAnalyzers) {
        PhraseSuggestionContext.DirectCandidateGenerator generator = new PhraseSuggestionContext.DirectCandidateGenerator();
        generator.setField(this.field);
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.size, generator::size);
        if (this.preFilter != null) {
            generator.preFilter(indexAnalyzers.get(this.preFilter));
            if (generator.preFilter() == null) {
                throw new IllegalArgumentException("Analyzer [" + this.preFilter + "] doesn't exists");
            }
        }
        if (this.postFilter != null) {
            generator.postFilter(indexAnalyzers.get(this.postFilter));
            if (generator.postFilter() == null) {
                throw new IllegalArgumentException("Analyzer [" + this.postFilter + "] doesn't exists");
            }
        }
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.accuracy, generator::accuracy);
        if (this.suggestMode != null) {
            generator.suggestMode(DirectCandidateGeneratorBuilder.resolveSuggestMode(this.suggestMode));
        }
        if (this.sort != null) {
            generator.sort(SortBy.resolve(this.sort));
        }
        if (this.stringDistance != null) {
            generator.stringDistance(DirectCandidateGeneratorBuilder.resolveDistance(this.stringDistance));
        }
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.maxEdits, generator::maxEdits);
        if (generator.maxEdits() < 1 || generator.maxEdits() > 2) {
            throw new IllegalArgumentException("Illegal max_edits value " + generator.maxEdits());
        }
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.maxInspections, generator::maxInspections);
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.maxTermFreq, generator::maxTermFreq);
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.prefixLength, generator::prefixLength);
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.minWordLength, generator::minWordLength);
        DirectCandidateGeneratorBuilder.transferIfNotNull(this.minDocFreq, generator::minDocFreq);
        return generator;
    }

    private static SuggestMode resolveSuggestMode(String suggestMode) {
        return switch (suggestMode = suggestMode.toLowerCase(Locale.US)) {
            case "missing" -> SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
            case "popular" -> SuggestMode.SUGGEST_MORE_POPULAR;
            case "always" -> SuggestMode.SUGGEST_ALWAYS;
            default -> throw new IllegalArgumentException("Illegal suggest mode " + suggestMode);
        };
    }

    static StringDistance resolveDistance(String distanceVal) {
        return switch (distanceVal = distanceVal.toLowerCase(Locale.ROOT)) {
            case "internal" -> DirectSpellChecker.INTERNAL_LEVENSHTEIN;
            case "damerau_levenshtein" -> new LuceneLevenshteinDistance();
            case "levenshtein" -> new LevenshteinDistance();
            case "jaro_winkler" -> new JaroWinklerDistance();
            case "ngram" -> new NGramDistance();
            default -> throw new IllegalArgumentException("Illegal distance option " + distanceVal);
        };
    }

    private static <T> void transferIfNotNull(T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.preFilter, this.postFilter, this.suggestMode, this.accuracy, this.size, this.sort, this.stringDistance, this.maxEdits, this.maxInspections, this.maxTermFreq, this.prefixLength, this.minWordLength, this.minDocFreq);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectCandidateGeneratorBuilder other = (DirectCandidateGeneratorBuilder)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.preFilter, other.preFilter) && Objects.equals(this.postFilter, other.postFilter) && Objects.equals(this.suggestMode, other.suggestMode) && Objects.equals(this.accuracy, other.accuracy) && Objects.equals(this.size, other.size) && Objects.equals(this.sort, other.sort) && Objects.equals(this.stringDistance, other.stringDistance) && Objects.equals(this.maxEdits, other.maxEdits) && Objects.equals(this.maxInspections, other.maxInspections) && Objects.equals(this.maxTermFreq, other.maxTermFreq) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.minWordLength, other.minWordLength) && Objects.equals(this.minDocFreq, other.minDocFreq);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELDNAME_FIELD);
        PARSER.declareString(DirectCandidateGeneratorBuilder::preFilter, PREFILTER_FIELD);
        PARSER.declareString(DirectCandidateGeneratorBuilder::postFilter, POSTFILTER_FIELD);
        PARSER.declareString(DirectCandidateGeneratorBuilder::suggestMode, SUGGESTMODE_FIELD);
        PARSER.declareFloat(DirectCandidateGeneratorBuilder::minDocFreq, MIN_DOC_FREQ_FIELD);
        PARSER.declareFloat(DirectCandidateGeneratorBuilder::accuracy, ACCURACY_FIELD);
        PARSER.declareInt(DirectCandidateGeneratorBuilder::size, SIZE_FIELD);
        PARSER.declareString(DirectCandidateGeneratorBuilder::sort, SORT_FIELD);
        PARSER.declareString(DirectCandidateGeneratorBuilder::stringDistance, STRING_DISTANCE_FIELD);
        PARSER.declareInt(DirectCandidateGeneratorBuilder::maxInspections, MAX_INSPECTIONS_FIELD);
        PARSER.declareFloat(DirectCandidateGeneratorBuilder::maxTermFreq, MAX_TERM_FREQ_FIELD);
        PARSER.declareInt(DirectCandidateGeneratorBuilder::maxEdits, MAX_EDITS_FIELD);
        PARSER.declareInt(DirectCandidateGeneratorBuilder::minWordLength, MIN_WORD_LENGTH_FIELD);
        PARSER.declareInt(DirectCandidateGeneratorBuilder::prefixLength, PREFIX_LENGTH_FIELD);
    }
}

