/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeCapabilities;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestAnalyzeAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/_analyze"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_analyze"));
    }

    @Override
    public String getName() {
        return "analyze_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            AnalyzeAction.Request analyzeRequest = AnalyzeAction.Request.fromXContent(parser, request.param("index"));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.admin().indices().analyze(analyzeRequest, new RestToXContentListener<AnalyzeAction.Response>((RestChannel)channel));
            return restChannelConsumer;
        }
    }

    @Override
    public Set<String> supportedCapabilities() {
        return AnalyzeCapabilities.CAPABILITIES;
    }
}

