/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.metadata;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class HealthMetadata
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "health";
    private static final ParseField DISK_METADATA = new ParseField("disk", new String[0]);
    private static final ParseField SHARD_LIMITS_METADATA = new ParseField("shard_limits", new String[0]);
    private final Disk diskMetadata;
    @Nullable
    private final ShardLimits shardLimitsMetadata;

    public HealthMetadata(Disk diskMetadata, ShardLimits shardLimitsMetadata) {
        this.diskMetadata = diskMetadata;
        this.shardLimitsMetadata = shardLimitsMetadata;
    }

    public HealthMetadata(StreamInput in) throws IOException {
        this.diskMetadata = Disk.readFrom(in);
        this.shardLimitsMetadata = in.getTransportVersion().onOrAfter(ShardLimits.VERSION_SUPPORTING_SHARD_LIMIT_FIELDS) ? in.readOptionalWriteable(ShardLimits::readFrom) : null;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_5_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.diskMetadata.writeTo(out);
        if (out.getTransportVersion().onOrAfter(ShardLimits.VERSION_SUPPORTING_SHARD_LIMIT_FIELDS)) {
            out.writeOptionalWriteable(this.shardLimitsMetadata);
        }
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return HealthMetadata.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> {
            builder.startObject(DISK_METADATA.getPreferredName());
            this.diskMetadata.toXContent(builder, params);
            builder.endObject();
            if (this.shardLimitsMetadata != null) {
                builder.startObject(SHARD_LIMITS_METADATA.getPreferredName());
                this.shardLimitsMetadata.toXContent(builder, params);
                builder.endObject();
            }
            return builder;
        });
    }

    public static HealthMetadata getFromClusterState(ClusterState clusterState) {
        return (HealthMetadata)clusterState.custom(TYPE);
    }

    public Disk getDiskMetadata() {
        return this.diskMetadata;
    }

    public ShardLimits getShardLimitsMetadata() {
        return this.shardLimitsMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthMetadata that = (HealthMetadata)o;
        return Objects.equals(this.diskMetadata, that.diskMetadata) && Objects.equals(this.shardLimitsMetadata, that.shardLimitsMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.diskMetadata, this.shardLimitsMetadata);
    }

    public String toString() {
        return "HealthMetadata{diskMetadata=" + Strings.toString(this.diskMetadata) + ", shardLimitsMetadata=" + String.valueOf(this.shardLimitsMetadata) + "}";
    }

    public static Builder newBuilder(HealthMetadata healthMetadata) {
        return new Builder(healthMetadata);
    }

    public record Disk(RelativeByteSizeValue highWatermark, ByteSizeValue highMaxHeadroom, RelativeByteSizeValue floodStageWatermark, ByteSizeValue floodStageMaxHeadroom, RelativeByteSizeValue frozenFloodStageWatermark, ByteSizeValue frozenFloodStageMaxHeadroom) implements ToXContentFragment,
    Writeable
    {
        public static final String TYPE = "disk";
        public static final TransportVersion VERSION_SUPPORTING_HEADROOM_FIELDS = TransportVersions.V_8_5_0;
        private static final ParseField HIGH_WATERMARK_FIELD = new ParseField("high_watermark", new String[0]);
        private static final ParseField HIGH_MAX_HEADROOM_FIELD = new ParseField("high_max_headroom", new String[0]);
        private static final ParseField FLOOD_STAGE_WATERMARK_FIELD = new ParseField("flood_stage_watermark", new String[0]);
        private static final ParseField FLOOD_STAGE_MAX_HEADROOM_FIELD = new ParseField("flood_stage_max_headroom", new String[0]);
        private static final ParseField FROZEN_FLOOD_STAGE_WATERMARK_FIELD = new ParseField("frozen_flood_stage_watermark", new String[0]);
        private static final ParseField FROZEN_FLOOD_STAGE_MAX_HEADROOM_FIELD = new ParseField("frozen_flood_stage_max_headroom", new String[0]);

        static Disk readFrom(StreamInput in) throws IOException {
            RelativeByteSizeValue highWatermark = RelativeByteSizeValue.parseRelativeByteSizeValue(in.readString(), HIGH_WATERMARK_FIELD.getPreferredName());
            RelativeByteSizeValue floodStageWatermark = RelativeByteSizeValue.parseRelativeByteSizeValue(in.readString(), FLOOD_STAGE_WATERMARK_FIELD.getPreferredName());
            RelativeByteSizeValue frozenFloodStageWatermark = RelativeByteSizeValue.parseRelativeByteSizeValue(in.readString(), FROZEN_FLOOD_STAGE_WATERMARK_FIELD.getPreferredName());
            ByteSizeValue frozenFloodStageMaxHeadroom = ByteSizeValue.readFrom(in);
            ByteSizeValue highMaxHeadroom = in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_HEADROOM_FIELDS) ? ByteSizeValue.readFrom(in) : ByteSizeValue.MINUS_ONE;
            ByteSizeValue floodStageMaxHeadroom = in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_HEADROOM_FIELDS) ? ByteSizeValue.readFrom(in) : ByteSizeValue.MINUS_ONE;
            return new Disk(highWatermark, highMaxHeadroom, floodStageWatermark, floodStageMaxHeadroom, frozenFloodStageWatermark, frozenFloodStageMaxHeadroom);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.describeHighWatermark());
            out.writeString(this.describeFloodStageWatermark());
            out.writeString(this.describeFrozenFloodStageWatermark());
            this.frozenFloodStageMaxHeadroom.writeTo(out);
            if (out.getTransportVersion().onOrAfter(VERSION_SUPPORTING_HEADROOM_FIELDS)) {
                this.highMaxHeadroom.writeTo(out);
                this.floodStageMaxHeadroom.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(HIGH_WATERMARK_FIELD.getPreferredName(), this.describeHighWatermark());
            builder.field(HIGH_MAX_HEADROOM_FIELD.getPreferredName(), this.highMaxHeadroom);
            builder.field(FLOOD_STAGE_WATERMARK_FIELD.getPreferredName(), this.describeFloodStageWatermark());
            builder.field(FLOOD_STAGE_MAX_HEADROOM_FIELD.getPreferredName(), this.floodStageMaxHeadroom);
            builder.field(FROZEN_FLOOD_STAGE_WATERMARK_FIELD.getPreferredName(), this.describeFrozenFloodStageWatermark());
            builder.field(FROZEN_FLOOD_STAGE_MAX_HEADROOM_FIELD.getPreferredName(), this.frozenFloodStageMaxHeadroom);
            return builder;
        }

        private static ByteSizeValue getFreeBytes(ByteSizeValue total, RelativeByteSizeValue watermark, ByteSizeValue maxHeadroom) {
            if (watermark.isAbsolute()) {
                return watermark.getAbsolute();
            }
            return ByteSizeValue.subtract(total, watermark.calculateValue(total, maxHeadroom));
        }

        public ByteSizeValue getFreeBytesHighWatermark(ByteSizeValue total) {
            return Disk.getFreeBytes(total, this.highWatermark, this.highMaxHeadroom);
        }

        public ByteSizeValue getFreeBytesFloodStageWatermark(ByteSizeValue total) {
            return Disk.getFreeBytes(total, this.floodStageWatermark, this.floodStageMaxHeadroom);
        }

        public ByteSizeValue getFreeBytesFrozenFloodStageWatermark(ByteSizeValue total) {
            return Disk.getFreeBytes(total, this.frozenFloodStageWatermark, this.frozenFloodStageMaxHeadroom);
        }

        private static String getThresholdStringRep(RelativeByteSizeValue relativeByteSizeValue) {
            if (relativeByteSizeValue.isAbsolute()) {
                return relativeByteSizeValue.getAbsolute().getStringRep();
            }
            return relativeByteSizeValue.getRatio().formatNoTrailingZerosPercent();
        }

        public String describeHighWatermark() {
            return Disk.getThresholdStringRep(this.highWatermark);
        }

        public String describeFloodStageWatermark() {
            return Disk.getThresholdStringRep(this.floodStageWatermark);
        }

        public String describeFrozenFloodStageWatermark() {
            return Disk.getThresholdStringRep(this.frozenFloodStageWatermark);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Disk disk = (Disk)o;
            return Objects.equals(this.describeHighWatermark(), disk.describeHighWatermark()) && Objects.equals(this.highMaxHeadroom, disk.highMaxHeadroom) && Objects.equals(this.describeFloodStageWatermark(), disk.describeFloodStageWatermark()) && Objects.equals(this.floodStageMaxHeadroom, disk.floodStageMaxHeadroom) && Objects.equals(this.describeFrozenFloodStageWatermark(), disk.describeFrozenFloodStageWatermark()) && Objects.equals(this.frozenFloodStageMaxHeadroom, disk.frozenFloodStageMaxHeadroom);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.describeHighWatermark(), this.highMaxHeadroom, this.describeFloodStageWatermark(), this.floodStageMaxHeadroom, this.describeFrozenFloodStageWatermark(), this.frozenFloodStageMaxHeadroom);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(Disk disk) {
            return new Builder(disk);
        }

        public static class Builder {
            private RelativeByteSizeValue highWatermark;
            private ByteSizeValue highMaxHeadroom;
            private RelativeByteSizeValue floodStageWatermark;
            private ByteSizeValue floodStageMaxHeadroom;
            private RelativeByteSizeValue frozenFloodStageWatermark;
            private ByteSizeValue frozenFloodStageMaxHeadroom;

            private Builder(Disk disk) {
                this.highWatermark = disk.highWatermark;
                this.highMaxHeadroom = disk.highMaxHeadroom;
                this.floodStageWatermark = disk.floodStageWatermark;
                this.floodStageMaxHeadroom = disk.floodStageMaxHeadroom;
                this.frozenFloodStageWatermark = disk.frozenFloodStageWatermark;
                this.frozenFloodStageMaxHeadroom = disk.frozenFloodStageMaxHeadroom;
            }

            private Builder() {
            }

            public Builder highWatermark(RelativeByteSizeValue highWatermark) {
                this.highWatermark = highWatermark;
                return this;
            }

            public Builder highWatermark(String highWatermark, String setting) {
                return this.highWatermark(RelativeByteSizeValue.parseRelativeByteSizeValue(highWatermark, setting));
            }

            public Builder highMaxHeadroom(ByteSizeValue highMaxHeadroom) {
                this.highMaxHeadroom = highMaxHeadroom;
                return this;
            }

            public Builder highMaxHeadroom(String highMaxHeadroom, String setting) {
                return this.highMaxHeadroom(ByteSizeValue.parseBytesSizeValue(highMaxHeadroom, setting));
            }

            public Builder floodStageWatermark(RelativeByteSizeValue floodStageWatermark) {
                this.floodStageWatermark = floodStageWatermark;
                return this;
            }

            public Builder floodStageWatermark(String floodStageWatermark, String setting) {
                return this.floodStageWatermark(RelativeByteSizeValue.parseRelativeByteSizeValue(floodStageWatermark, setting));
            }

            public Builder floodStageMaxHeadroom(ByteSizeValue floodStageMaxHeadroom) {
                this.floodStageMaxHeadroom = floodStageMaxHeadroom;
                return this;
            }

            public Builder floodStageMaxHeadroom(String floodStageMaxHeadroom, String setting) {
                return this.floodStageMaxHeadroom(ByteSizeValue.parseBytesSizeValue(floodStageMaxHeadroom, setting));
            }

            public Builder frozenFloodStageWatermark(RelativeByteSizeValue frozenFloodStageWatermark) {
                this.frozenFloodStageWatermark = frozenFloodStageWatermark;
                return this;
            }

            public Builder frozenFloodStageWatermark(String frozenFloodStageWatermark, String setting) {
                return this.frozenFloodStageWatermark(RelativeByteSizeValue.parseRelativeByteSizeValue(frozenFloodStageWatermark, setting));
            }

            public Builder frozenFloodStageMaxHeadroom(ByteSizeValue frozenFloodStageMaxHeadroom) {
                this.frozenFloodStageMaxHeadroom = frozenFloodStageMaxHeadroom;
                return this;
            }

            public Builder frozenFloodStageMaxHeadroom(String frozenFloodStageMaxHeadroom, String setting) {
                return this.frozenFloodStageMaxHeadroom(ByteSizeValue.parseBytesSizeValue(frozenFloodStageMaxHeadroom, setting));
            }

            public Disk build() {
                return new Disk(this.highWatermark, this.highMaxHeadroom, this.floodStageWatermark, this.floodStageMaxHeadroom, this.frozenFloodStageWatermark, this.frozenFloodStageMaxHeadroom);
            }
        }
    }

    public record ShardLimits(int maxShardsPerNode, int maxShardsPerNodeFrozen) implements ToXContentFragment,
    Writeable
    {
        private static final String TYPE = "shard_limits";
        private static final ParseField MAX_SHARDS_PER_NODE = new ParseField("max_shards_per_node", new String[0]);
        private static final ParseField MAX_SHARDS_PER_NODE_FROZEN = new ParseField("max_shards_per_node_frozen", new String[0]);
        static final TransportVersion VERSION_SUPPORTING_SHARD_LIMIT_FIELDS = TransportVersions.V_8_8_0;

        static ShardLimits readFrom(StreamInput in) throws IOException {
            return new ShardLimits(in.readInt(), in.readInt());
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MAX_SHARDS_PER_NODE.getPreferredName(), this.maxShardsPerNode);
            builder.field(MAX_SHARDS_PER_NODE_FROZEN.getPreferredName(), this.maxShardsPerNodeFrozen);
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.maxShardsPerNode);
            out.writeInt(this.maxShardsPerNodeFrozen);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(ShardLimits shardLimits) {
            return new Builder(shardLimits);
        }

        public static class Builder {
            private int maxShardsPerNode;
            private int maxShardsPerNodeFrozen;

            private Builder() {
            }

            private Builder(ShardLimits shardLimits) {
                this.maxShardsPerNode = shardLimits.maxShardsPerNode;
                this.maxShardsPerNodeFrozen = shardLimits.maxShardsPerNodeFrozen;
            }

            public Builder maxShardsPerNode(int maxShardsPerNode) {
                this.maxShardsPerNode = maxShardsPerNode;
                return this;
            }

            public Builder maxShardsPerNodeFrozen(int maxShardsPerNodeFrozen) {
                this.maxShardsPerNodeFrozen = maxShardsPerNodeFrozen;
                return this;
            }

            public ShardLimits build() {
                return new ShardLimits(this.maxShardsPerNode, this.maxShardsPerNodeFrozen);
            }
        }
    }

    public static class Builder {
        private Disk disk;
        private ShardLimits shardLimits;

        private Builder(HealthMetadata healthMetadata) {
            this.disk = healthMetadata.diskMetadata;
            this.shardLimits = healthMetadata.shardLimitsMetadata;
        }

        public Builder disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        public Builder shardLimits(ShardLimits shardLimits) {
            this.shardLimits = shardLimits;
            return this;
        }

        public HealthMetadata build() {
            return new HealthMetadata(this.disk, this.shardLimits);
        }
    }
}

