/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.ResettableValue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamLifecycle
implements SimpleDiffable<DataStreamLifecycle>,
ToXContentObject {
    public static final TransportVersion ADDED_ENABLED_FLAG_VERSION = TransportVersions.V_8_10_X;
    public static final String EFFECTIVE_RETENTION_REST_API_CAPABILITY = "data_stream_lifecycle_effective_retention";
    public static final String DATA_STREAMS_LIFECYCLE_ONLY_SETTING_NAME = "data_streams.lifecycle_only.mode";
    public static final String INCLUDE_EFFECTIVE_RETENTION_PARAM_NAME = "include_effective_retention";
    public static final Map<String, String> INCLUDE_EFFECTIVE_RETENTION_PARAMS = Map.of("include_effective_retention", "true");
    public static final Tuple<TimeValue, RetentionSource> INFINITE_RETENTION = Tuple.tuple(null, RetentionSource.DATA_STREAM_CONFIGURATION);
    private static final String DOWNSAMPLING_NOT_SUPPORTED_ERROR_MESSAGE = "Failure store lifecycle does not support downsampling, please remove the downsampling configuration.";
    public static final Setting<RolloverConfiguration> CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING = new Setting<RolloverConfiguration>("cluster.lifecycle.default.rollover", "max_age=auto,max_primary_shard_size=50gb,min_docs=1,max_primary_shard_docs=200000000", s -> RolloverConfiguration.parseSetting(s, "cluster.lifecycle.default.rollover"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final DataStreamLifecycle DEFAULT_DATA_LIFECYCLE = DataStreamLifecycle.createDataLifecycle(null, null, null);
    public static final DataStreamLifecycle DEFAULT_FAILURE_LIFECYCLE = DataStreamLifecycle.createFailuresLifecycle(null, null);
    public static final String DATA_STREAM_LIFECYCLE_ORIGIN = "data_stream_lifecycle";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField DATA_RETENTION_FIELD = new ParseField("data_retention", new String[0]);
    public static final ParseField EFFECTIVE_RETENTION_FIELD = new ParseField("effective_retention", new String[0]);
    public static final ParseField RETENTION_SOURCE_FIELD = new ParseField("retention_determined_by", new String[0]);
    public static final ParseField DOWNSAMPLING_FIELD = new ParseField("downsampling", new String[0]);
    private static final ParseField ROLLOVER_FIELD = new ParseField("rollover", new String[0]);
    public static final ConstructingObjectParser<DataStreamLifecycle, LifecycleType> PARSER = new ConstructingObjectParser<DataStreamLifecycle, LifecycleType>("lifecycle", false, (args, lt) -> new DataStreamLifecycle((LifecycleType)lt, (Boolean)args[0], (TimeValue)args[1], (List)args[2]));
    private final LifecycleType lifecycleType;
    private final boolean enabled;
    @Nullable
    private final TimeValue dataRetention;
    @Nullable
    private final List<DownsamplingRound> downsampling;

    public static boolean isDataStreamsLifecycleOnlyMode(Settings settings) {
        return settings.getAsBoolean(DATA_STREAMS_LIFECYCLE_ONLY_SETTING_NAME, false);
    }

    DataStreamLifecycle(LifecycleType lifecycleType, @Nullable Boolean enabled, @Nullable TimeValue dataRetention, @Nullable List<DownsamplingRound> downsampling) {
        this.lifecycleType = lifecycleType;
        this.enabled = enabled == null || enabled != false;
        this.dataRetention = dataRetention;
        if (lifecycleType == LifecycleType.FAILURES && downsampling != null) {
            throw new IllegalArgumentException(DOWNSAMPLING_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        DownsamplingRound.validateRounds(downsampling);
        this.downsampling = downsampling;
    }

    public static DataStreamLifecycle createDataLifecycle(@Nullable Boolean enabled, @Nullable TimeValue dataRetention, @Nullable List<DownsamplingRound> downsampling) {
        return new DataStreamLifecycle(LifecycleType.DATA, enabled, dataRetention, downsampling);
    }

    public static DataStreamLifecycle createFailuresLifecycle(@Nullable Boolean enabled, @Nullable TimeValue dataRetention) {
        return new DataStreamLifecycle(LifecycleType.FAILURES, enabled, dataRetention, null);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean targetsFailureStore() {
        return this.lifecycleType == LifecycleType.FAILURES;
    }

    public String getLifecycleType() {
        return this.lifecycleType.label;
    }

    @Nullable
    public TimeValue getEffectiveDataRetention(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        return this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream).v1();
    }

    public Tuple<TimeValue, RetentionSource> getEffectiveDataRetentionWithSource(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        if (!this.enabled()) {
            return INFINITE_RETENTION;
        }
        if (globalRetention == null || isInternalDataStream) {
            return Tuple.tuple(this.dataRetention(), RetentionSource.DATA_STREAM_CONFIGURATION);
        }
        if (this.dataRetention() == null) {
            return globalRetention.defaultRetention() != null ? Tuple.tuple(globalRetention.defaultRetention(), this.targetsFailureStore() ? RetentionSource.DEFAULT_FAILURES_RETENTION : RetentionSource.DEFAULT_GLOBAL_RETENTION) : Tuple.tuple(globalRetention.maxRetention(), RetentionSource.MAX_GLOBAL_RETENTION);
        }
        if (globalRetention.maxRetention() != null && globalRetention.maxRetention().getMillis() < this.dataRetention().getMillis()) {
            return Tuple.tuple(globalRetention.maxRetention(), RetentionSource.MAX_GLOBAL_RETENTION);
        }
        return Tuple.tuple(this.dataRetention(), RetentionSource.DATA_STREAM_CONFIGURATION);
    }

    @Nullable
    public TimeValue dataRetention() {
        return this.dataRetention;
    }

    public void addWarningHeaderIfDataRetentionNotEffective(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        if (globalRetention == null || isInternalDataStream) {
            return;
        }
        Tuple<TimeValue, RetentionSource> effectiveDataRetentionWithSource = this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream);
        if (effectiveDataRetentionWithSource.v1() == null) {
            return;
        }
        String effectiveRetentionStringRep = effectiveDataRetentionWithSource.v1().getStringRep();
        switch (effectiveDataRetentionWithSource.v2()) {
            case DEFAULT_GLOBAL_RETENTION: {
                HeaderWarning.addWarning("Not providing a retention is not allowed for this project. The default retention of [" + effectiveRetentionStringRep + "] will be applied.", new Object[0]);
                break;
            }
            case MAX_GLOBAL_RETENTION: {
                String retentionProvidedPart = this.dataRetention() == null ? "Not providing a retention is not allowed for this project." : "The retention provided [" + (this.dataRetention() == null ? "infinite" : this.dataRetention().getStringRep()) + "] is exceeding the max allowed data retention of this project [" + effectiveRetentionStringRep + "].";
                HeaderWarning.addWarning(retentionProvidedPart + " The max retention of [" + effectiveRetentionStringRep + "] will be applied", new Object[0]);
                break;
            }
        }
    }

    @Nullable
    public List<DownsamplingRound> downsampling() {
        return this.downsampling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamLifecycle that = (DataStreamLifecycle)o;
        return this.lifecycleType == that.lifecycleType && Objects.equals(this.dataRetention, that.dataRetention) && Objects.equals(this.downsampling, that.downsampling) && this.enabled == that.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.lifecycleType, this.enabled, this.dataRetention, this.downsampling);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19)) {
                out.writeOptionalTimeValue(this.dataRetention);
            } else {
                DataStreamLifecycle.writeLegacyOptionalValue(this.dataRetention, out, StreamOutput::writeTimeValue);
            }
        }
        if (out.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
            if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19)) {
                out.writeOptionalCollection(this.downsampling);
            } else {
                DataStreamLifecycle.writeLegacyOptionalValue(this.downsampling, out, StreamOutput::writeCollection);
            }
            out.writeBoolean(this.enabled());
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19)) {
            this.lifecycleType.writeTo(out);
        }
    }

    public DataStreamLifecycle(StreamInput in) throws IOException {
        this.dataRetention = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? (in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19) ? in.readOptionalTimeValue() : DataStreamLifecycle.readLegacyOptionalValue(in, StreamInput::readTimeValue)) : null;
        if (in.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
            this.downsampling = in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19) ? in.readOptionalCollectionAsList(DownsamplingRound::read) : DataStreamLifecycle.readLegacyOptionalValue(in, is -> is.readCollectionAsList(DownsamplingRound::read));
            this.enabled = in.readBoolean();
        } else {
            this.downsampling = null;
            this.enabled = true;
        }
        this.lifecycleType = in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19) ? LifecycleType.read(in) : LifecycleType.DATA;
    }

    private static <T> void writeLegacyOptionalValue(T value, StreamOutput out, Writeable.Writer<T> writer) throws IOException {
        boolean isDefined = value != null;
        out.writeBoolean(isDefined);
        if (isDefined) {
            out.writeBoolean(true);
            writer.write(out, value);
        }
    }

    private static <T> T readLegacyOptionalValue(StreamInput in, Writeable.Reader<T> reader) throws IOException {
        boolean isNotNull;
        T value = null;
        boolean isDefined = in.readBoolean();
        if (isDefined && (isNotNull = in.readBoolean())) {
            value = reader.read(in);
        }
        return value;
    }

    public static Diff<DataStreamLifecycle> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamLifecycle::new, in);
    }

    public String toString() {
        return "DataStreamLifecycle{lifecycleTarget=" + String.valueOf(this.lifecycleType) + ", enabled=" + this.enabled + ", dataRetention=" + String.valueOf(this.dataRetention) + ", downsampling=" + String.valueOf(this.downsampling) + "}";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null, null, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.dataRetention != null) {
            builder.field(DATA_RETENTION_FIELD.getPreferredName(), this.dataRetention.getStringRep());
        }
        Tuple<TimeValue, RetentionSource> effectiveDataRetentionWithSource = this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream);
        if (params.paramAsBoolean(INCLUDE_EFFECTIVE_RETENTION_PARAM_NAME, false) && effectiveDataRetentionWithSource.v1() != null) {
            builder.field(EFFECTIVE_RETENTION_FIELD.getPreferredName(), effectiveDataRetentionWithSource.v1().getStringRep());
            builder.field(RETENTION_SOURCE_FIELD.getPreferredName(), effectiveDataRetentionWithSource.v2().displayName());
        }
        if (this.downsampling != null) {
            builder.field(DOWNSAMPLING_FIELD.getPreferredName(), (Iterable<?>)this.downsampling);
        }
        if (rolloverConfiguration != null) {
            builder.field(ROLLOVER_FIELD.getPreferredName());
            rolloverConfiguration.evaluateAndConvertToXContent(builder, params, effectiveDataRetentionWithSource.v1());
        }
        builder.endObject();
        return builder;
    }

    public static DataStreamLifecycle dataLifecycleFromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, LifecycleType.DATA);
    }

    public static DataStreamLifecycle failureLifecycleFromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, LifecycleType.FAILURES);
    }

    public static ToXContent.Params addEffectiveRetentionParams(ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(INCLUDE_EFFECTIVE_RETENTION_PARAMS, params);
    }

    public static Template createDataLifecycleTemplate(boolean enabled, TimeValue dataRetention, List<DownsamplingRound> downsampling) {
        return new Template(LifecycleType.DATA, enabled, ResettableValue.create(dataRetention), ResettableValue.create(downsampling));
    }

    public static Template createDataLifecycleTemplate(boolean enabled, ResettableValue<TimeValue> dataRetention, ResettableValue<List<DownsamplingRound>> downsampling) {
        return new Template(LifecycleType.DATA, enabled, dataRetention, downsampling);
    }

    public static Template createFailuresLifecycleTemplate(boolean enabled, TimeValue dataRetention) {
        return new Template(LifecycleType.FAILURES, enabled, ResettableValue.create(dataRetention), ResettableValue.undefined());
    }

    public static Builder builder(DataStreamLifecycle lifecycle) {
        return new Builder(lifecycle);
    }

    public static Builder builder(Template template) {
        return new Builder(template);
    }

    public static Builder dataLifecycleBuilder() {
        return new Builder(LifecycleType.DATA);
    }

    public static Builder failuresLifecycleBuilder() {
        return new Builder(LifecycleType.FAILURES);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            String value = p.textOrNull();
            if (value == null) {
                return null;
            }
            return TimeValue.parseTimeValue(value, DATA_RETENTION_FIELD.getPreferredName());
        }, DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return AbstractObjectParser.parseArray(p, null, DownsamplingRound::fromXContent);
        }, DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
    }

    static enum LifecycleType implements Writeable
    {
        DATA("data", 0),
        FAILURES("failures", 1);

        private final String label;
        private final byte id;
        private static final Map<Byte, LifecycleType> REGISTRY;

        private LifecycleType(String label, byte id) {
            this.label = label;
            this.id = id;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.write(this.id);
        }

        public static LifecycleType read(StreamInput in) throws IOException {
            return REGISTRY.get(in.readByte());
        }

        static {
            REGISTRY = Arrays.stream(LifecycleType.values()).collect(Collectors.toMap(l -> l.id, Function.identity()));
        }
    }

    public record DownsamplingRound(TimeValue after, DownsampleConfig config) implements Writeable,
    ToXContentObject
    {
        public static final ParseField AFTER_FIELD = new ParseField("after", new String[0]);
        public static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
        public static final long FIVE_MINUTES_MILLIS = TimeValue.timeValueMinutes(5L).getMillis();
        private static final ConstructingObjectParser<DownsamplingRound, Void> PARSER = new ConstructingObjectParser<DownsamplingRound, Void>("downsampling_round", false, (args, unused) -> new DownsamplingRound((TimeValue)args[0], new DownsampleConfig((DateHistogramInterval)args[1])));

        public DownsamplingRound {
            if (config.getFixedInterval().estimateMillis() < FIVE_MINUTES_MILLIS) {
                throw new IllegalArgumentException("A downsampling round must have a fixed interval of at least five minutes but found: " + String.valueOf(config.getFixedInterval()));
            }
        }

        static void validateRounds(List<DownsamplingRound> rounds) {
            if (rounds == null) {
                return;
            }
            if (rounds.isEmpty()) {
                throw new IllegalArgumentException("Downsampling configuration should have at least one round configured.");
            }
            if (rounds.size() > 10) {
                throw new IllegalArgumentException("Downsampling configuration supports maximum 10 configured rounds. Found: " + rounds.size());
            }
            DownsamplingRound previous = null;
            for (DownsamplingRound round : rounds) {
                if (previous == null) {
                    previous = round;
                    continue;
                }
                if (round.after.compareTo(previous.after) < 0) {
                    throw new IllegalArgumentException("A downsampling round must have a later 'after' value than the proceeding, " + round.after.getStringRep() + " is not after " + previous.after.getStringRep() + ".");
                }
                DownsampleConfig.validateSourceAndTargetIntervals(previous.config(), round.config());
            }
        }

        public static DownsamplingRound read(StreamInput in) throws IOException {
            return new DownsamplingRound(in.readTimeValue(), new DownsampleConfig(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeTimeValue(this.after);
            out.writeWriteable(this.config);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(AFTER_FIELD.getPreferredName(), this.after.getStringRep());
            this.config.toXContentFragment(builder);
            builder.endObject();
            return builder;
        }

        public static DownsamplingRound fromXContent(XContentParser parser, Void context) throws IOException {
            return PARSER.parse(parser, context);
        }

        @Override
        public String toString() {
            return Strings.toString(this, true, true);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), value -> TimeValue.parseTimeValue(value, AFTER_FIELD.getPreferredName()), AFTER_FIELD);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(FIXED_INTERVAL_FIELD.getPreferredName(), new String[0]), ObjectParser.ValueType.STRING);
        }
    }

    public static enum RetentionSource {
        DATA_STREAM_CONFIGURATION,
        DEFAULT_GLOBAL_RETENTION,
        MAX_GLOBAL_RETENTION,
        DEFAULT_FAILURES_RETENTION;


        public String displayName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public record Template(LifecycleType lifecycleType, boolean enabled, ResettableValue<TimeValue> dataRetention, ResettableValue<List<DownsamplingRound>> downsampling) implements ToXContentObject,
    Writeable
    {
        public static final Template DATA_DEFAULT = new Template(LifecycleType.DATA, true, ResettableValue.undefined(), ResettableValue.undefined());
        public static final ConstructingObjectParser<Template, LifecycleType> PARSER = new ConstructingObjectParser<Template, LifecycleType>("lifecycle_template", false, (args, lt) -> new Template((LifecycleType)lt, args[0] == null || (Boolean)args[0] != false, args[1] == null ? ResettableValue.undefined() : (ResettableValue)args[1], args[2] == null ? ResettableValue.undefined() : (ResettableValue)args[2]));

        Template(LifecycleType lifecycleType, boolean enabled, TimeValue dataRetention, List<DownsamplingRound> downsampling) {
            this(lifecycleType, enabled, ResettableValue.create(dataRetention), ResettableValue.create(downsampling));
        }

        public Template {
            if (lifecycleType == LifecycleType.FAILURES && downsampling.get() != null) {
                throw new IllegalArgumentException(DataStreamLifecycle.DOWNSAMPLING_NOT_SUPPORTED_ERROR_MESSAGE);
            }
            if (downsampling.isDefined() && downsampling.get() != null) {
                DownsamplingRound.validateRounds(downsampling.get());
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19)) {
                    ResettableValue.write(out, this.dataRetention, StreamOutput::writeTimeValue);
                } else {
                    Template.writeLegacyValue(out, this.dataRetention, StreamOutput::writeTimeValue);
                }
            }
            if (out.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
                if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19)) {
                    ResettableValue.write(out, this.downsampling, StreamOutput::writeCollection);
                } else {
                    Template.writeLegacyValue(out, this.downsampling, StreamOutput::writeCollection);
                }
                out.writeBoolean(this.enabled);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19)) {
                this.lifecycleType.writeTo(out);
            }
        }

        private static <T> void writeLegacyValue(StreamOutput out, ResettableValue<T> value, Writeable.Writer<T> writer) throws IOException {
            out.writeBoolean(value.isDefined());
            if (value.isDefined()) {
                out.writeBoolean(!value.shouldReset());
                if (!value.shouldReset()) {
                    writer.write(out, value.get());
                }
            }
        }

        static <T> ResettableValue<T> readLegacyValues(StreamInput in, Writeable.Reader<T> reader) throws IOException {
            boolean isDefined = in.readBoolean();
            if (!isDefined) {
                return ResettableValue.undefined();
            }
            boolean hasNonNullValue = in.readBoolean();
            if (!hasNonNullValue) {
                return ResettableValue.reset();
            }
            T value = reader.read(in);
            return ResettableValue.create(value);
        }

        public static Template read(StreamInput in) throws IOException {
            boolean enabled = true;
            ResettableValue<TimeValue> dataRetention = ResettableValue.undefined();
            ResettableValue<List<DownsamplingRound>> downsampling = ResettableValue.undefined();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                dataRetention = in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19) ? ResettableValue.read(in, StreamInput::readTimeValue) : Template.readLegacyValues(in, StreamInput::readTimeValue);
            }
            if (in.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
                downsampling = in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_LIFECYCLE_TEMPLATE_8_19) ? ResettableValue.read(in, i -> i.readCollectionAsList(DownsamplingRound::read)) : Template.readLegacyValues(in, i -> i.readCollectionAsList(DownsamplingRound::read));
                enabled = in.readBoolean();
            }
            LifecycleType lifecycleTarget = in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19) ? LifecycleType.read(in) : LifecycleType.DATA;
            return new Template(lifecycleTarget, enabled, dataRetention, downsampling);
        }

        public static Template dataLifecycleTemplateFromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, LifecycleType.DATA);
        }

        public static Template failuresLifecycleTemplateFromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, LifecycleType.FAILURES);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.toXContent(builder, params, null, null, false);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) throws IOException {
            builder.startObject();
            builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
            this.dataRetention.toXContent(builder, params, DATA_RETENTION_FIELD.getPreferredName(), TimeValue::getStringRep);
            this.downsampling.toXContent(builder, params, DOWNSAMPLING_FIELD.getPreferredName());
            if (rolloverConfiguration != null) {
                builder.field(ROLLOVER_FIELD.getPreferredName());
                rolloverConfiguration.evaluateAndConvertToXContent(builder, params, this.toDataStreamLifecycle().getEffectiveDataRetention(globalRetention, isInternalDataStream));
            }
            builder.endObject();
            return builder;
        }

        public DataStreamLifecycle toDataStreamLifecycle() {
            return new DataStreamLifecycle(this.lifecycleType, this.enabled, this.dataRetention.get(), this.downsampling.get());
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                String value = p.textOrNull();
                return value == null ? ResettableValue.reset() : ResettableValue.create(TimeValue.parseTimeValue(value, DATA_RETENTION_FIELD.getPreferredName()));
            }, DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                    return ResettableValue.reset();
                }
                return ResettableValue.create(AbstractObjectParser.parseArray(p, null, DownsamplingRound::fromXContent));
            }, DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
        }
    }

    public static class Builder {
        private final LifecycleType lifecycleType;
        private boolean enabled = true;
        @Nullable
        private TimeValue dataRetention = null;
        @Nullable
        private List<DownsamplingRound> downsampling = null;

        private Builder(LifecycleType lifecycleType) {
            this.lifecycleType = lifecycleType;
        }

        private Builder(Template template) {
            this.lifecycleType = template.lifecycleType();
            this.enabled = template.enabled();
            this.dataRetention = template.dataRetention().get();
            this.downsampling = template.downsampling().get();
        }

        private Builder(DataStreamLifecycle lifecycle) {
            this.lifecycleType = lifecycle.lifecycleType;
            this.enabled = lifecycle.enabled();
            this.dataRetention = lifecycle.dataRetention();
            this.downsampling = lifecycle.downsampling();
        }

        public Builder composeTemplate(Template template) {
            assert (this.lifecycleType == template.lifecycleType()) : "Trying to compose templates with different lifecycle types";
            this.enabled(template.enabled());
            this.dataRetention(template.dataRetention());
            this.downsampling(template.downsampling());
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder dataRetention(ResettableValue<TimeValue> dataRetention) {
            if (dataRetention.isDefined()) {
                this.dataRetention = dataRetention.get();
            }
            return this;
        }

        public Builder dataRetention(@Nullable TimeValue dataRetention) {
            this.dataRetention = dataRetention;
            return this;
        }

        public Builder downsampling(ResettableValue<List<DownsamplingRound>> downsampling) {
            if (downsampling.isDefined()) {
                this.downsampling = downsampling.get();
            }
            return this;
        }

        public Builder downsampling(@Nullable List<DownsamplingRound> downsampling) {
            this.downsampling = downsampling;
            return this;
        }

        public DataStreamLifecycle build() {
            return new DataStreamLifecycle(this.lifecycleType, this.enabled, this.dataRetention, this.downsampling);
        }

        public Template buildTemplate() {
            return new Template(this.lifecycleType, this.enabled, this.dataRetention, this.downsampling);
        }
    }
}

