/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PatternTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final String flags;
    @Nullable
    private final Integer group;
    @Nullable
    private final String pattern;
    public static final JsonpDeserializer<PatternTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternTokenizer::setupPatternTokenizerDeserializer);

    private PatternTokenizer(Builder builder) {
        super(builder);
        this.flags = builder.flags;
        this.group = builder.group;
        this.pattern = builder.pattern;
    }

    public static PatternTokenizer of(Function<Builder, ObjectBuilder<PatternTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Pattern;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nullable
    public final Integer group() {
        return this.group;
    }

    @Nullable
    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern");
        super.serializeInternal(generator, mapper);
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        if (this.group != null) {
            generator.writeKey("group");
            generator.write(this.group);
        }
        if (this.pattern != null) {
            generator.writeKey("pattern");
            generator.write(this.pattern);
        }
    }

    protected static void setupPatternTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::group, JsonpDeserializer.integerDeserializer(), "group");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternTokenizer> {
        @Nullable
        private String flags;
        @Nullable
        private Integer group;
        @Nullable
        private String pattern;

        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        public final Builder group(@Nullable Integer value) {
            this.group = value;
            return this;
        }

        public final Builder pattern(@Nullable String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternTokenizer build() {
            this._checkSingleUse();
            return new PatternTokenizer(this);
        }
    }
}

