/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestLowercase {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestLowercase::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("mutate", IngestLowercase.lowercaseHash(processor)));
    }

    static String lowercaseHash(Map<String, Map> processor) {
        Map lowercase_data = processor.get("lowercase");
        return IngestConverter.createField("lowercase", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)lowercase_data.get("field"))));
    }

    public static boolean has_lowercase(Map<String, Object> processor) {
        return processor.containsKey("lowercase");
    }
}

