"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateESQLControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _esql_control_helpers = require("./esql_control_helpers");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CreateESQLControlAction {
  constructor(core, search, timefilter) {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_CREATE_ESQL_CONTROL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_CREATE_ESQL_CONTROL);
    (0, _defineProperty2.default)(this, "order", 50);
    this.core = core;
    this.search = search;
    this.timefilter = timefilter;
  }
  getDisplayName() {
    return _i18n.i18n.translate('esql.createESQLControlLabel', {
      defaultMessage: 'Creates an ES|QL control'
    });
  }
  getIconType() {
    return 'pencil';
  }
  async isCompatible({
    variableType
  }) {
    return (0, _esql_control_helpers.isActionCompatible)(this.core, variableType);
  }
  async execute({
    queryString,
    variableType,
    esqlVariables,
    onSaveControl,
    onCancelControl,
    cursorPosition,
    initialState
  }) {
    return (0, _esql_control_helpers.executeAction)({
      queryString,
      core: this.core,
      search: this.search,
      timefilter: this.timefilter,
      variableType,
      esqlVariables,
      onSaveControl,
      onCancelControl,
      cursorPosition,
      initialState
    });
  }
}
exports.CreateESQLControlAction = CreateESQLControlAction;