"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedAttackDiscoveryPrompt = void 0;
var _fp = require("lodash/fp");
var _get_alerts_context_prompt = require("../../generate/helpers/get_alerts_context_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the the initial query, or the initial query combined with a
 * continuation prompt and partial results
 */
const getCombinedAttackDiscoveryPrompt = ({
  anonymizedAlerts,
  attackDiscoveryPrompt,
  combinedMaybePartialResults,
  continuePrompt
}) => {
  const alertsContextPrompt = (0, _get_alerts_context_prompt.getAlertsContextPrompt)({
    anonymizedAlerts,
    attackDiscoveryPrompt
  });
  return (0, _fp.isEmpty)(combinedMaybePartialResults) ? alertsContextPrompt // no partial results yet
  : `${alertsContextPrompt}

${continuePrompt}

"""
${combinedMaybePartialResults}
"""

`;
};
exports.getCombinedAttackDiscoveryPrompt = getCombinedAttackDiscoveryPrompt;