"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityPercentageIndicator = QualityPercentageIndicator;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEW_QUALITY_STATS_DOCS_THRESHOLD = 0.0005;
function QualityPercentageIndicator({
  percentage,
  docsCount = 0,
  fewDocsTooltipContent
}) {
  const isFewDocsAvailable = percentage && percentage < FEW_QUALITY_STATS_DOCS_THRESHOLD;
  return isFewDocsAvailable ? /*#__PURE__*/_react.default.createElement(DatasetWithFewQualityStatsDocs, {
    docsCount: docsCount,
    fewDocsTooltipContent: fewDocsTooltipContent
  }) : /*#__PURE__*/_react.default.createElement(DatasetWithManyQualityStatsDocs, {
    percentage: percentage
  });
}
const DatasetWithFewQualityStatsDocs = ({
  docsCount,
  fewDocsTooltipContent
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, "~0%", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: fewDocsTooltipContent(docsCount)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning",
    size: "s"
  })));
};
const DatasetWithManyQualityStatsDocs = ({
  percentage
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: Number(percentage.toFixed(2))
  }), "%");
};