"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Main = Main;
require("../../../index.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/share-plugin/public");
var _get_console_tour_step_props = require("./get_console_tour_step_props");
var _contexts = require("../../contexts");
var _i18n2 = require("./i18n");
var _nav_icon_button = require("./nav_icon_button");
var _editor = require("../editor");
var _config = require("../config");
var _components = require("../../components");
var _history = require("../history");
var _hooks = require("../../hooks");
var _get_top_nav = require("./get_top_nav");
var _get_tour_steps = require("./get_tour_steps");
var _import_confirm_modal = require("./import_confirm_modal");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// 2MB limit (2 * 1024 * 1024 bytes)
const MAX_FILE_UPLOAD_SIZE = 2 * 1024 * 1024;
function Main({
  currentTabProp,
  isEmbeddable = false
}) {
  var _currentTextObject$te;
  const dispatch = (0, _contexts.useEditorActionContext)();
  const requestDispatch = (0, _contexts.useRequestActionContext)();
  const {
    currentView
  } = (0, _contexts.useEditorReadContext)();
  const currentTab = currentTabProp !== null && currentTabProp !== void 0 ? currentTabProp : currentView;
  const [isShortcutsOpen, setIsShortcutsOpen] = (0, _react.useState)(false);
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(false);
  const [isFullscreenOpen, setIsFullScreen] = (0, _react.useState)(false);
  const [isConfirmImportOpen, setIsConfirmImportOpen] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    docLinks,
    services: {
      notifications,
      routeHistory
    }
  } = (0, _contexts.useServicesContext)();
  const storageTourState = localStorage.getItem(_constants.TOUR_STORAGE_KEY);
  const initialTourState = storageTourState ? JSON.parse(storageTourState) : _constants.INITIAL_TOUR_CONFIG;
  const [tourStepProps, actions, tourState] = (0, _eui.useEuiTour)((0, _get_tour_steps.getTourSteps)(docLinks), initialTourState);
  (0, _react.useEffect)(() => {
    localStorage.setItem(_constants.TOUR_STORAGE_KEY, JSON.stringify(tourState));
  }, [tourState]);

  // Clean up request output when switching tabs
  (0, _react.useEffect)(() => {
    requestDispatch({
      type: 'cleanRequest',
      payload: undefined
    });
  }, [currentView, requestDispatch]);
  const consoleTourStepProps = (0, _get_console_tour_step_props.getConsoleTourStepProps)(tourStepProps, actions, tourState);
  const {
    done,
    error,
    retry
  } = (0, _hooks.useDataInit)();
  const {
    currentTextObject
  } = (0, _contexts.useEditorReadContext)();
  const [inputEditorValue, setInputEditorValue] = (0, _react.useState)((_currentTextObject$te = currentTextObject === null || currentTextObject === void 0 ? void 0 : currentTextObject.text) !== null && _currentTextObject$te !== void 0 ? _currentTextObject$te : '');
  const updateTab = tab => {
    if (routeHistory) {
      routeHistory === null || routeHistory === void 0 ? void 0 : routeHistory.push(`/console/${tab}`);
    } else {
      dispatch({
        type: 'setCurrentView',
        payload: tab
      });
    }
  };
  const toggleFullscreen = () => {
    const isEnabled = !isFullscreenOpen;
    setIsFullScreen(isEnabled);
    if (isEnabled) {
      var _document$querySelect;
      (_document$querySelect = document.querySelector('#consoleRoot')) === null || _document$querySelect === void 0 ? void 0 : _document$querySelect.requestFullscreen();
    } else {
      document.exitFullscreen();
    }
  };
  const onFileChange = event => {
    const files = event.target.files;
    const file = files && files[0];
    // Clear the input value so that a file can be imported again
    event.target.value = '';
    if (file) {
      if (file.size > MAX_FILE_UPLOAD_SIZE) {
        notifications.toasts.addWarning(_i18n.i18n.translate('console.notification.error.fileTooBigMessage', {
          defaultMessage: `File size exceeds the 2MB limit.`
        }));
        return;
      }
      const reader = new FileReader();
      reader.onerror = () => {
        notifications.toasts.addWarning(_i18n.i18n.translate('console.notification.error.failedToReadFile', {
          defaultMessage: `Failed to read the file you selected.`
        }));
      };
      reader.onload = e => {
        var _e$target;
        const fileContent = e === null || e === void 0 ? void 0 : (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.result;
        if (fileContent) {
          setIsConfirmImportOpen(fileContent);
        } else {
          notifications.toasts.addWarning(_i18n.i18n.translate('console.notification.error.fileImportNoContent', {
            defaultMessage: `The file you selected doesn't appear to have any content. Please select a different file.`
          }));
        }
      };
      reader.readAsText(file);
    }
  };
  const scrollablePanelStyle = (0, _react2.css)`
    ${(0, _eui.useEuiOverflowScroll)('y', false)}
  `;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_components.SomethingWentWrongCallout, {
      onButtonClick: retry,
      error: error
    }));
  }
  if (!currentTextObject) return null;
  const shortcutsButton = /*#__PURE__*/_react.default.createElement(_nav_icon_button.NavIconButton, {
    iconType: "keyboard",
    onClick: () => setIsShortcutsOpen(!isShortcutsOpen),
    ariaLabel: _i18n2.MAIN_PANEL_LABELS.shortcutsButton,
    dataTestSubj: "consoleShortcutsButton",
    toolTipContent: _i18n2.MAIN_PANEL_LABELS.shortcutsButton
  });
  const helpButton = /*#__PURE__*/_react.default.createElement(_nav_icon_button.NavIconButton, {
    iconType: "question",
    onClick: () => setIsHelpOpen(!isHelpOpen),
    ariaLabel: _i18n2.MAIN_PANEL_LABELS.helpButton,
    dataTestSubj: "consoleHelpButton",
    toolTipContent: _i18n2.MAIN_PANEL_LABELS.helpButton
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    id: "consoleRoot",
    className: `consoleContainer${isEmbeddable ? '--embeddable' : ''}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, _i18n2.MAIN_PANEL_LABELS.consolePageHeading)), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    borderRadius: isEmbeddable ? 'none' : 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    className: "consoleTabs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.TopNavMenu, {
    disabled: !done,
    items: (0, _get_top_nav.getTopNavConfig)({
      selectedTab: currentTab,
      setSelectedTab: tab => updateTab(tab)
    }),
    tourStepProps: consoleTourStepProps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ConsoleTourStep, {
    tourStepProps: consoleTourStepProps[_constants.FILES_TOUR_STEP - 1]
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n2.MAIN_PANEL_LABELS.exportButtonTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "exportAction",
    disabled: inputEditorValue === '',
    onClick: () => (0, _public.downloadFileAs)(_constants.EXPORT_FILE_NAME, {
      content: inputEditorValue,
      type: 'text/plain'
    }),
    size: "xs",
    "data-test-subj": "consoleExportButton"
  }, _i18n2.MAIN_PANEL_LABELS.exportButton)), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n2.MAIN_PANEL_LABELS.importButtonTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "importAction",
    onClick: () => {
      var _document$getElementB;
      return (_document$getElementB = document.getElementById('importConsoleFile')) === null || _document$getElementB === void 0 ? void 0 : _document$getElementB.click();
    },
    size: "xs",
    "data-test-subj": "consoleImportButton"
  }, _i18n2.MAIN_PANEL_LABELS.importButton)), /*#__PURE__*/_react.default.createElement("input", {
    type: "file",
    accept: "text/*",
    multiple: false,
    name: "consoleSnippets",
    id: "importConsoleFile",
    onChange: onFileChange
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ShortcutsPopover, {
    button: shortcutsButton,
    isOpen: isShortcutsOpen,
    closePopover: () => setIsShortcutsOpen(false)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.HelpPopover, {
    button: helpButton,
    isOpen: isHelpOpen,
    closePopover: () => setIsHelpOpen(false),
    resetTour: () => {
      setIsHelpOpen(false);
      updateTab(_constants.SHELL_TAB_ID);
      actions.resetTour();
    }
  })), isEmbeddable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_nav_icon_button.NavIconButton, {
    iconType: isFullscreenOpen ? 'fullScreenExit' : 'fullScreen',
    onClick: toggleFullscreen,
    ariaLabel: isFullscreenOpen ? _i18n2.MAIN_PANEL_LABELS.closeFullscrenButton : _i18n2.MAIN_PANEL_LABELS.openFullscrenButton,
    dataTestSubj: "consoleToggleFullscreenButton",
    toolTipContent: isFullscreenOpen ? _i18n2.MAIN_PANEL_LABELS.closeFullscrenButton : _i18n2.MAIN_PANEL_LABELS.openFullscrenButton
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: [scrollablePanelStyle, {
      backgroundColor: euiTheme.colors.body
    }],
    "data-test-subj": "consolePanel"
  }, currentTab === _constants.SHELL_TAB_ID && /*#__PURE__*/_react.default.createElement(_editor.Editor, {
    loading: !done,
    inputEditorValue: inputEditorValue,
    setInputEditorValue: setInputEditorValue
  }), currentTab === _constants.HISTORY_TAB_ID && /*#__PURE__*/_react.default.createElement(_history.History, null), currentTab === _constants.CONFIG_TAB_ID && /*#__PURE__*/_react.default.createElement(_config.Config, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "xs",
    grow: false,
    className: "consoleVariablesBottomBar",
    color: "plain"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => updateTab(_constants.CONFIG_TAB_ID),
    iconType: "editorCodeBlock",
    size: "xs",
    color: "text"
  }, _i18n2.MAIN_PANEL_LABELS.variablesButton))), /*#__PURE__*/_react.default.createElement(_components.ConsoleTourStep, {
    tourStepProps: consoleTourStepProps[_constants.EDITOR_TOUR_STEP - 1]
  }, /*#__PURE__*/_react.default.createElement("div", null)), isConfirmImportOpen && /*#__PURE__*/_react.default.createElement(_import_confirm_modal.ImportConfirmModal, {
    onClose: () => setIsConfirmImportOpen(null),
    fileContent: isConfirmImportOpen
  }));
}