"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = ColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _palette_colors = require("./palette_colors");
var _rgb_picker = require("./rgb_picker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ColorPicker({
  color,
  palette,
  palettes,
  close,
  selectColor,
  deleteStep
}) {
  const [tab, setTab] = (0, _react.useState)(color.type === 'categorical' && (color.paletteId === palette.id || color.paletteId === _palettes.KbnPalette.Neutral) ? 'palette' : 'custom');
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 168
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "none",
    style: {
      borderBottom: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    expand: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "lns-colorMapping-colorPicker-tab-colors",
    onClick: () => setTab('palette'),
    isSelected: tab === 'palette'
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.paletteTabLabel', {
    defaultMessage: 'Colors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "lns-colorMapping-colorPicker-tab-custom",
    onClick: () => setTab('custom'),
    isSelected: tab === 'custom'
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.customTabLabel', {
    defaultMessage: 'Custom'
  })))), tab === 'palette' ? /*#__PURE__*/_react.default.createElement(_palette_colors.PaletteColors, {
    color: color,
    palette: palette,
    palettes: palettes,
    selectColor: selectColor
  }) : /*#__PURE__*/_react.default.createElement(_rgb_picker.RGBPicker, {
    color: color,
    selectColor: selectColor,
    palettes: palettes
  }), deleteStep ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "xs",
    iconType: "trash",
    onClick: () => {
      close();
      deleteStep();
    },
    style: {
      paddingBottom: 8
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.removeGradientColorButtonLabel', {
    defaultMessage: 'Remove color stop'
  }))) : null);
}